/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.model.jpa.source.metadata;

import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import org.babyfish.model.jpa.source.ElementHelper;
import org.babyfish.model.jpa.source.metadata.MetadataClass;
import org.babyfish.model.jpa.source.metadata.MetadataProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataAssociation
extends MetadataProperty {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetadataAssociation.class);
    private boolean collection;
    private Object relatedMetadataClass;

    MetadataAssociation(MetadataClass owner, Element element) {
        super(owner, element);
        this.collection = ElementHelper.containsAnyAnnotation(element, OneToMany.class, ManyToMany.class);
        Class targetEntity = null;
        if (ElementHelper.containsAnyAnnotation(element, OneToOne.class)) {
            targetEntity = (Class)ElementHelper.getAnnotationValue(element, OneToOne.class, "targetEntity");
        } else if (ElementHelper.containsAnyAnnotation(element, ManyToOne.class)) {
            targetEntity = (Class)ElementHelper.getAnnotationValue(element, ManyToOne.class, "targetEntity");
        } else if (ElementHelper.containsAnyAnnotation(element, OneToMany.class)) {
            targetEntity = (Class)ElementHelper.getAnnotationValue(element, OneToMany.class, "targetEntity");
        } else if (ElementHelper.containsAnyAnnotation(element, ManyToMany.class)) {
            targetEntity = (Class)ElementHelper.getAnnotationValue(element, ManyToMany.class, "targetEntity");
        }
        if (targetEntity == null || targetEntity == Void.TYPE) {
            DeclaredType declaredType = element instanceof ExecutableElement ? (DeclaredType)((ExecutableElement)element).getReturnType() : (DeclaredType)element.asType();
            if (this.collection) {
                List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
                if (typeArguments.isEmpty()) {
                    String message = "The association \"" + this.name + "\" of \"" + this.getOwner().getName() + "\" is invalid, it has neither targetEntity of \"" + "@" + (ElementHelper.containsAnyAnnotation(element, OneToMany.class) ? OneToMany.class.getName() : ManyToMany.class.getName()) + "\" nor type arguments.";
                    LOGGER.error(message);
                    throw new IllegalArgumentException(message);
                }
                this.relatedMetadataClass = typeArguments.get(typeArguments.size() - 1).toString();
            } else {
                this.relatedMetadataClass = declaredType.toString();
            }
        } else {
            this.relatedMetadataClass = targetEntity.getName();
        }
    }

    public boolean isCollection() {
        return this.collection;
    }

    public MetadataClass getRelatedMetadataClass() {
        return (MetadataClass)this.relatedMetadataClass;
    }

    void secondaryPass(Map<String, MetadataClass> metaClasses) {
        String oppositeEndpointName = (String)this.relatedMetadataClass;
        this.relatedMetadataClass = metaClasses.get(oppositeEndpointName);
        if (this.relatedMetadataClass == null) {
            throw new IllegalArgumentException("Failed to resolve association property " + this.owner.getName() + '.' + this.name + ", because there is no opposite entity: " + oppositeEndpointName);
        }
    }
}

