/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.model.jpa.source.metadata;

import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Entity;
import javax.persistence.Id;
import org.babyfish.collection.LinkedHashMap;
import org.babyfish.collection.MACollections;
import org.babyfish.collection.XOrderedMap;
import org.babyfish.model.jpa.source.ElementHelper;
import org.babyfish.model.jpa.source.metadata.MetadataAssociation;
import org.babyfish.model.jpa.source.metadata.MetadataProperty;
import org.babyfish.model.jpa.source.metadata.MetadataScalar;

public class MetadataClass {
    private boolean entity;
    private String name;
    private String simpleName;
    private String packageName;
    private XOrderedMap<String, MetadataProperty> properties;
    private XOrderedMap<String, MetadataAssociation> associations;
    private XOrderedMap<String, MetadataScalar> scalars;
    private Object supperMetadataClass;
    private AccessType accessType;

    public MetadataClass(TypeElement typeElement) {
        MetadataAssociation association;
        MetadataScalar scalar;
        MetadataProperty property;
        this.entity = ElementHelper.containsAnyAnnotation(typeElement, Entity.class);
        this.name = typeElement.getQualifiedName().toString();
        this.simpleName = typeElement.getSimpleName().toString();
        Element enclosing = typeElement.getEnclosingElement();
        while (true) {
            if (enclosing.getKind() == ElementKind.PACKAGE) break;
            enclosing = enclosing.getEnclosingElement();
        }
        this.packageName = ((PackageElement)enclosing).getQualifiedName().toString();
        this.accessType = this.getDefaultAccessType(typeElement);
        LinkedHashMap properties = new LinkedHashMap();
        LinkedHashMap associations = new LinkedHashMap();
        LinkedHashMap scalars = new LinkedHashMap();
        for (Element element : ElementFilter.fieldsIn(typeElement.getEnclosedElements())) {
            property = MetadataProperty.of(this, element);
            if (property instanceof MetadataScalar) {
                scalar = (MetadataScalar)property;
                properties.put((Object)scalar.getName(), (Object)scalar);
                scalars.put((Object)scalar.getName(), (Object)scalar);
                continue;
            }
            if (!(property instanceof MetadataAssociation)) continue;
            association = (MetadataAssociation)property;
            properties.put((Object)association.getName(), (Object)association);
            associations.put((Object)association.getName(), (Object)association);
        }
        for (Element element : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
            property = MetadataProperty.of(this, element);
            if (property instanceof MetadataScalar) {
                scalar = (MetadataScalar)property;
                properties.put((Object)scalar.getName(), (Object)scalar);
                scalars.put((Object)scalar.getName(), (Object)scalar);
                continue;
            }
            if (!(property instanceof MetadataAssociation)) continue;
            association = (MetadataAssociation)property;
            properties.put((Object)association.getName(), (Object)association);
            associations.put((Object)association.getName(), (Object)association);
        }
        this.properties = MACollections.unmodifiable((XOrderedMap)properties);
        this.associations = MACollections.unmodifiable((XOrderedMap)associations);
        this.scalars = MACollections.unmodifiable((XOrderedMap)scalars);
        this.supperMetadataClass = typeElement.getSuperclass();
    }

    public boolean isEntity() {
        return this.entity;
    }

    public String getName() {
        return this.name;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public AccessType getAccessType() {
        return this.accessType;
    }

    public MetadataClass getSuperMetadataClass() {
        return (MetadataClass)this.supperMetadataClass;
    }

    public Map<String, MetadataProperty> getProperties() {
        return this.properties;
    }

    public Map<String, MetadataAssociation> getAssociations() {
        return this.associations;
    }

    public Map<String, MetadataScalar> getScalars() {
        return this.scalars;
    }

    public void secondaryPass(Map<String, MetadataClass> metadataClasses) {
        TypeMirror superType = (TypeMirror)this.supperMetadataClass;
        this.supperMetadataClass = null;
        while (superType instanceof DeclaredType) {
            MetadataClass superMetadataClass = metadataClasses.get(superType.toString());
            if (superMetadataClass != null) {
                this.supperMetadataClass = superMetadataClass;
                break;
            }
            superType = ((TypeElement)((DeclaredType)superType).asElement()).getSuperclass();
        }
        for (MetadataAssociation association : this.associations.values()) {
            association.secondaryPass(metadataClasses);
        }
        for (MetadataScalar scalar : this.scalars.values()) {
            scalar.secondaryPass(metadataClasses);
        }
    }

    private AccessType getDefaultAccessType(TypeElement typeElement) {
        TypeElement typeElement2;
        AccessType accessType = ElementHelper.getAnnotationEnumValue(typeElement, Access.class, "value", AccessType.class);
        if (accessType != null) {
            return accessType;
        }
        for (Element element : ElementFilter.fieldsIn(typeElement.getEnclosedElements())) {
            if (!ElementHelper.containsAnyAnnotation(element, Id.class)) continue;
            return AccessType.FIELD;
        }
        for (Element element : ElementFilter.fieldsIn(typeElement.getEnclosedElements())) {
            if (!ElementHelper.containsAnyAnnotation(element, Id.class)) continue;
            return AccessType.FIELD;
        }
        TypeMirror superTypeMirror = typeElement.getSuperclass();
        if (superTypeMirror instanceof DeclaredType && !(typeElement2 = (TypeElement)((DeclaredType)superTypeMirror).asElement()).getQualifiedName().equals(Object.class.getName())) {
            return this.getDefaultAccessType(typeElement2);
        }
        return AccessType.PROPERTY;
    }
}

