/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.model.jpa.source.metadata;

import java.util.ResourceBundle;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Transient;
import org.babyfish.lang.IllegalProgramException;
import org.babyfish.lang.Strings;
import org.babyfish.lang.internal.I18NUtils;
import org.babyfish.lang.internal.Instrumented;
import org.babyfish.model.jpa.source.ElementHelper;
import org.babyfish.model.jpa.source.TypedQueryPathProcessor;
import org.babyfish.model.jpa.source.metadata.MetadataAssociation;
import org.babyfish.model.jpa.source.metadata.MetadataClass;
import org.babyfish.model.jpa.source.metadata.MetadataScalar;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Instrumented
public class MetadataProperty {
    private static ResourceBundle {resourceBundle};
    protected MetadataClass owner;
    protected String name;

    static MetadataProperty of(MetadataClass owner, Element element) {
        if (element.getModifiers().contains((Object)Modifier.STATIC)) {
            return null;
        }
        if (ElementHelper.containsAnyAnnotation(element, Transient.class)) {
            return null;
        }
        AccessType forceAccessType = ElementHelper.getAnnotationEnumValue(element, Access.class, "value", AccessType.class);
        if (element.getKind() == ElementKind.FIELD) {
            if (owner.getAccessType() != AccessType.FIELD && forceAccessType != AccessType.FIELD) {
                return null;
            }
        } else if (element.getKind() == ElementKind.METHOD) {
            if (owner.getAccessType() != AccessType.PROPERTY && forceAccessType != AccessType.PROPERTY) {
                return null;
            }
        } else {
            return null;
        }
        if (ElementHelper.containsAnyAnnotation(element, OneToOne.class, ManyToOne.class, OneToMany.class, ManyToMany.class)) {
            return new MetadataAssociation(owner, element);
        }
        if (element instanceof VariableElement) {
            return new MetadataScalar(owner, element);
        }
        String methodName = element.getSimpleName().toString();
        if (methodName.startsWith("get") || methodName.startsWith("is")) {
            return new MetadataScalar(owner, element);
        }
        return null;
    }

    MetadataProperty(MetadataClass owner, Element element) {
        this.owner = owner;
        String name = element.getSimpleName().toString();
        if (!(element instanceof VariableElement)) {
            name = element.getSimpleName().toString();
            if (name.startsWith("get")) {
                if (name.length() == 3) {
                    throw new IllegalProgramException(MetadataProperty.methodNameIsInvalid(owner.getName(), "get"));
                }
                name = name.substring(3);
            } else if (name.startsWith("is")) {
                if (name.length() == 2) {
                    throw new IllegalProgramException(MetadataProperty.methodNameIsInvalid(owner.getName(), "is"));
                }
                name = name.substring(2);
            } else {
                throw new IllegalProgramException(MetadataProperty.methodNameIsInvalid(owner.getName(), element.getSimpleName().toString()));
            }
            name = Strings.toCamelCase((String)name);
        }
        if (name.equals("end")) {
            throw new IllegalProgramException(MetadataProperty.propertyNameIsNotAllowed(owner.getName(), "end", TypedQueryPathProcessor.class));
        }
        if (name.equals("asc")) {
            throw new IllegalProgramException(MetadataProperty.propertyNameIsNotAllowed(owner.getName(), "asc", TypedQueryPathProcessor.class));
        }
        if (name.equals("desc")) {
            throw new IllegalProgramException(MetadataProperty.propertyNameIsNotAllowed(owner.getName(), "desc", TypedQueryPathProcessor.class));
        }
        this.name = name;
    }

    public MetadataClass getOwner() {
        return this.owner;
    }

    public String getName() {
        return this.name;
    }

    private static String methodNameIsInvalid(String arg0, String arg1) {
        ResourceBundle bundle = {resourceBundle};
        if (bundle == null) {
            {resourceBundle} = bundle = ResourceBundle.getBundle("org/babyfish/model/jpa/source/metadata/MetadataProperty");
        }
        return {resourceBundle}.getString("methodNameIsInvalid").replace("{0}", I18NUtils.toString((Object)arg0)).replace("{1}", I18NUtils.toString((Object)arg1));
    }

    private static String propertyNameIsNotAllowed(String arg0, String arg1, Class arg2) {
        ResourceBundle bundle = {resourceBundle};
        if (bundle == null) {
            {resourceBundle} = bundle = ResourceBundle.getBundle("org/babyfish/model/jpa/source/metadata/MetadataProperty");
        }
        return {resourceBundle}.getString("propertyNameIsNotAllowed").replace("{0}", I18NUtils.toString((Object)arg0)).replace("{1}", I18NUtils.toString((Object)arg1)).replace("{2}", I18NUtils.toString((Object)arg2));
    }
}

