/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.model.jpa.source.metadata;

import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.DeclaredType;
import javax.persistence.Basic;
import javax.persistence.Embedded;
import javax.persistence.FetchType;
import org.babyfish.model.jpa.source.ElementHelper;
import org.babyfish.model.jpa.source.metadata.MetadataClass;
import org.babyfish.model.jpa.source.metadata.MetadataProperty;

public class MetadataScalar
extends MetadataProperty {
    private boolean embedded;
    private boolean lazy;
    private Object relatedMetadataClass;

    MetadataScalar(MetadataClass owner, Element element) {
        super(owner, element);
        this.embedded = ElementHelper.containsAnyAnnotation(element, Embedded.class);
        this.lazy = FetchType.LAZY.name().equals(ElementHelper.getAnnotationValue(element, Basic.class, "fetch"));
        if (this.embedded) {
            this.relatedMetadataClass = element instanceof ExecutableElement ? ((DeclaredType)((ExecutableElement)element).getReturnType()).toString() : ((DeclaredType)element.asType()).toString();
        }
    }

    public boolean isEmbedded() {
        return this.embedded;
    }

    public boolean isLazy() {
        return this.lazy;
    }

    public MetadataClass getRelatedMetadataClass() {
        return (MetadataClass)this.relatedMetadataClass;
    }

    void secondaryPass(Map<String, MetadataClass> metaClasses) {
        String embeddedName = (String)this.relatedMetadataClass;
        if (embeddedName != null) {
            this.relatedMetadataClass = metaClasses.get(embeddedName);
            if (this.relatedMetadataClass == null) {
                throw new IllegalArgumentException("Failed to resolve the embedded property " + this.owner.getName() + '.' + this.name + ", because there is no opposite emembeddable type: " + embeddedName);
            }
        }
    }
}

