/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.impl.validation;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ValidationException;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Validator<T> {
    private static final Pattern I18N_PATTERN = Pattern.compile("\\{[^}]+}");
    private static ResourceBundle BUNDLE;
    private final String message;
    private final List<ConstraintValidator<?, T>> constraintValidators;

    public Validator(@NotNull Class<? extends Annotation> annotationType, @NotNull String message, @NotNull Class<?> type, @Nullable Integer propId) {
        ImmutableProp prop = propId != null ? ImmutableType.get(type).getProp(propId) : null;
        Annotation annotation = prop != null ? prop.getAnnotation(annotationType) : type.getAnnotation(annotationType);
        if (message.isEmpty()) {
            message = Validator.tryGetDefaultMessage(annotation);
        }
        this.message = !message.isEmpty() ? Validator.translateMessage(message) : (prop != null ? "'" + type.getName() + '.' + prop.getName() + "' does not match the validation rule of @" + annotationType.getName() : "'" + type.getName() + "' does not match the validation rule of @" + annotationType.getName());
        Constraint constraint = annotationType.getAnnotation(Constraint.class);
        ArrayList constraintValidators = new ArrayList();
        for (Class validatorType : new LinkedHashSet<Class>(Arrays.asList(constraint.validatedBy()))) {
            ConstraintValidator constraintValidator;
            try {
                constraintValidator = (ConstraintValidator)validatorType.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException ex) {
                throw new IllegalArgumentException("Cannot create constraint validator instance of \"" + validatorType.getName() + "\" declared by the annotation \"@" + annotationType.getName() + "\"", ex);
            }
            catch (InvocationTargetException ex) {
                throw new IllegalArgumentException("Cannot create constraint validator instance of \"" + validatorType.getName() + "\" declared by the annotation \"@" + annotationType.getName() + "\"", ex.getTargetException());
            }
            constraintValidator.initialize(annotation);
            constraintValidators.add(constraintValidator);
        }
        this.constraintValidators = constraintValidators;
    }

    public void validate(T value) {
        for (ConstraintValidator<?, T> constraintValidator : this.constraintValidators) {
            if (constraintValidator.isValid(value, null)) continue;
            throw new ValidationException(this.message);
        }
    }

    private static String tryGetDefaultMessage(Annotation annotation) {
        Method method;
        try {
            method = annotation.annotationType().getMethod("message", new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            return "";
        }
        if (method.getReturnType() != String.class) {
            return "";
        }
        try {
            return (String)method.invoke((Object)annotation, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            throw new AssertionError("Internal bug", ex);
        }
    }

    private static String translateMessage(String message) {
        StringBuilder builder = new StringBuilder();
        Matcher matcher = I18N_PATTERN.matcher(message);
        int pos = 0;
        while (matcher.find()) {
            if (matcher.start() != pos) {
                builder.append(message.substring(pos, matcher.start()));
            }
            builder.append(Validator.bundle().getString(message.substring(matcher.start() + 1, matcher.end() - 1)));
            pos = matcher.end();
        }
        if (pos == 0) {
            return message;
        }
        if (pos != message.length()) {
            builder.append(message.substring(pos));
        }
        return builder.toString();
    }

    private static ResourceBundle bundle() {
        ResourceBundle bundle = BUNDLE;
        if (bundle == null) {
            BUNDLE = bundle = ResourceBundle.getBundle("ValidationMessages");
        }
        return bundle;
    }
}

