/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.kimmer.sql.ast;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.babyfish.kimmer.sql.ast.AbstractExpression;
import org.babyfish.kimmer.sql.ast.AstVisitor;
import org.babyfish.kimmer.sql.ast.Expression;
import org.babyfish.kimmer.sql.ast.SqlBuilder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B)\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\f\u0010\u0012\u001a\u00020\u000f*\u00020\u0013H\u0014R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/babyfish/kimmer/sql/ast/BinaryExpression;", "T", "", "Lorg/babyfish/kimmer/sql/ast/AbstractExpression;", "operator", "", "left", "Lorg/babyfish/kimmer/sql/ast/Expression;", "right", "(Ljava/lang/String;Lorg/babyfish/kimmer/sql/ast/Expression;Lorg/babyfish/kimmer/sql/ast/Expression;)V", "precedence", "", "getPrecedence", "()I", "accept", "", "visitor", "Lorg/babyfish/kimmer/sql/ast/AstVisitor;", "render", "Lorg/babyfish/kimmer/sql/ast/SqlBuilder;", "kimmer-sql"})
public final class BinaryExpression<T extends Number>
extends AbstractExpression<T> {
    @NotNull
    private final String operator;
    @NotNull
    private final Expression<T> left;
    @NotNull
    private final Expression<T> right;

    public BinaryExpression(@NotNull String operator, @NotNull Expression<T> left, @NotNull Expression<T> right) {
        Intrinsics.checkNotNullParameter((Object)operator, (String)"operator");
        Intrinsics.checkNotNullParameter(left, (String)"left");
        Intrinsics.checkNotNullParameter(right, (String)"right");
        super(left.getSelectedType());
        this.operator = operator;
        this.left = left;
        this.right = right;
    }

    @Override
    protected int getPrecedence() {
        int n;
        switch (this.operator) {
            case "%": 
            case "*": 
            case "/": {
                n = 2;
                break;
            }
            default: {
                n = 3;
            }
        }
        return n;
    }

    @Override
    protected void render(@NotNull SqlBuilder $this$render) {
        Intrinsics.checkNotNullParameter((Object)$this$render, (String)"<this>");
        this.render($this$render, this.left);
        $this$render.sql(" ");
        $this$render.sql(this.operator);
        $this$render.sql(" ");
        this.render($this$render, this.right);
    }

    @Override
    public void accept(@NotNull AstVisitor visitor) {
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        this.left.accept(visitor);
        this.right.accept(visitor);
    }
}

