/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.kimmer.sql.ast;

import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import org.babyfish.kimmer.sql.ast.AbstractExpression;
import org.babyfish.kimmer.sql.ast.AstVisitor;
import org.babyfish.kimmer.sql.ast.SqlBuilder;
import org.babyfish.kimmer.sql.ast.table.Table;
import org.babyfish.kimmer.sql.ast.table.impl.TableImpl;
import org.babyfish.kimmer.sql.meta.EntityProp;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001d\u0012\u000e\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\f\u0010\u0015\u001a\u00020\u0012*\u00020\u0016H\u0014R\u0014\u0010\t\u001a\u00020\n8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0019\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0017"}, d2={"Lorg/babyfish/kimmer/sql/ast/PropExpression;", "T", "", "Lorg/babyfish/kimmer/sql/ast/AbstractExpression;", "table", "Lorg/babyfish/kimmer/sql/ast/table/impl/TableImpl;", "prop", "Lorg/babyfish/kimmer/sql/meta/EntityProp;", "(Lorg/babyfish/kimmer/sql/ast/table/impl/TableImpl;Lorg/babyfish/kimmer/sql/meta/EntityProp;)V", "precedence", "", "getPrecedence", "()I", "getProp", "()Lorg/babyfish/kimmer/sql/meta/EntityProp;", "getTable", "()Lorg/babyfish/kimmer/sql/ast/table/impl/TableImpl;", "accept", "", "visitor", "Lorg/babyfish/kimmer/sql/ast/AstVisitor;", "render", "Lorg/babyfish/kimmer/sql/ast/SqlBuilder;", "kimmer-sql"})
public final class PropExpression<T>
extends AbstractExpression<T> {
    @NotNull
    private final TableImpl<?, ?> table;
    @NotNull
    private final EntityProp prop;

    public PropExpression(@NotNull TableImpl<?, ?> table, @NotNull EntityProp prop) {
        Intrinsics.checkNotNullParameter(table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)prop, (String)"prop");
        super(JvmClassMappingKt.getJavaClass(prop.getReturnType()));
        this.table = table;
        this.prop = prop;
        if (this.prop.getTargetType() != null) {
            throw new IllegalArgumentException("Can not get '" + this.prop.getName() + "' form table because it's association, please use joinReference, joinList or joinConnection");
        }
        if (this.prop.getStorage() == null) {
            throw new IllegalArgumentException("Can not get '" + this.prop.getName() + "' form table because it's not stored property");
        }
    }

    @NotNull
    public final TableImpl<?, ?> getTable() {
        return this.table;
    }

    @NotNull
    public final EntityProp getProp() {
        return this.prop;
    }

    @Override
    protected int getPrecedence() {
        return 0;
    }

    @Override
    protected void render(@NotNull SqlBuilder $this$render) {
        Intrinsics.checkNotNullParameter((Object)$this$render, (String)"<this>");
        this.table.renderSelection(this.prop, $this$render, false);
    }

    @Override
    public void accept(@NotNull AstVisitor visitor) {
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        visitor.visitTableReference((Table)this.table, this.prop);
    }
}

