/*
 * Decompiled with CFR 0.152.
 */
package org.bakeneko.rabbitmq.rpc;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bakeneko.rabbitmq.rpc.EnableRabbitRPC;
import org.bakeneko.rabbitmq.rpc.RabbitClient;
import org.bakeneko.rabbitmq.rpc.factory.PropertiesResolverImpl;
import org.bakeneko.rabbitmq.rpc.factory.RabbitClientAnnotationProcessorImpl;
import org.bakeneko.rabbitmq.rpc.factory.RabbitClientFactoryImpl;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class RabbitClientRegistrar
implements ImportBeanDefinitionRegistrar,
ResourceLoaderAware,
BeanClassLoaderAware {
    private ClassPathScanner classpathScanner = new ClassPathScanner();
    private ClassLoader classLoader;
    private ResourceLoader resourceLoader;
    private static final String PROPERTIES_RESOLVER_BEAN_NAME = PropertiesResolverImpl.class.getName();
    private static final String ANNOTATION_PROCESSOR_BEAN_NAME = RabbitClientAnnotationProcessorImpl.class.getName();
    private static final String CLIENT_FACTORY_BEAN_NAME = RabbitClientFactoryImpl.class.getName();

    public RabbitClientRegistrar() {
        this.classpathScanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(RabbitClient.class));
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void registerBeanDefinitions(AnnotationMetadata annotationMetadata, BeanDefinitionRegistry registry) {
        Assert.notNull((Object)annotationMetadata, (String)"AnnotationMetadata must not be null!");
        Assert.notNull((Object)registry, (String)"BeanDefinitionRegistry must not be null!");
        Assert.notNull((Object)this.resourceLoader, (String)"ResourceLoader must not be null!");
        if (annotationMetadata.getAnnotationAttributes(EnableRabbitRPC.class.getName()) != null) {
            this.registerDefinitionIfMissing(PROPERTIES_RESOLVER_BEAN_NAME, PropertiesResolverImpl.class, registry);
            this.registerDefinitionIfMissing(ANNOTATION_PROCESSOR_BEAN_NAME, RabbitClientAnnotationProcessorImpl.class, registry);
            this.registerDefinitionIfMissing(CLIENT_FACTORY_BEAN_NAME, RabbitClientFactoryImpl.class, registry);
            this.getBasePackages(annotationMetadata).forEach(p -> this.createRabbitClients((String)p, registry));
        }
    }

    private <T> void registerDefinitionIfMissing(String beanName, Class<T> beanType, BeanDefinitionRegistry registry) {
        if (!registry.containsBeanDefinition(beanName)) {
            registry.registerBeanDefinition(beanName, (BeanDefinition)new RootBeanDefinition(beanType));
        }
    }

    private Set<String> getBasePackages(AnnotationMetadata importingClassMetadata) {
        Map attributes = importingClassMetadata.getAnnotationAttributes(EnableRabbitRPC.class.getCanonicalName());
        HashSet<String> basePackages = new HashSet<String>();
        for (String pkg : (String[])attributes.get("value")) {
            if (!StringUtils.hasText((String)pkg)) continue;
            basePackages.add(pkg);
        }
        for (String pkg : (String[])attributes.get("basePackages")) {
            if (!StringUtils.hasText((String)pkg)) continue;
            basePackages.add(pkg);
        }
        for (Class clazz : (Class[])attributes.get("basePackageClasses")) {
            basePackages.add(ClassUtils.getPackageName((Class)clazz));
        }
        if (basePackages.isEmpty()) {
            basePackages.add(ClassUtils.getPackageName((String)importingClassMetadata.getClassName()));
        }
        return basePackages;
    }

    private void createRabbitClients(String basePackage, BeanDefinitionRegistry registry) {
        try {
            for (BeanDefinition beanDefinition : this.classpathScanner.findCandidateComponents(basePackage)) {
                Class<?> clazz = Class.forName(beanDefinition.getBeanClassName());
                String beanName = this.getBeanName(clazz);
                GenericBeanDefinition proxyBeanDefinition = new GenericBeanDefinition();
                proxyBeanDefinition.setBeanClass(clazz);
                ConstructorArgumentValues args = new ConstructorArgumentValues();
                args.addGenericArgumentValue((Object)this.classLoader);
                args.addGenericArgumentValue(clazz);
                proxyBeanDefinition.setConstructorArgumentValues(args);
                proxyBeanDefinition.setFactoryBeanName(CLIENT_FACTORY_BEAN_NAME);
                proxyBeanDefinition.setFactoryMethodName("forType");
                registry.registerBeanDefinition(beanName, (BeanDefinition)proxyBeanDefinition);
            }
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    private String getBeanName(Class<?> clazz) {
        String qualifier;
        String string = qualifier = clazz.isAnnotationPresent(Qualifier.class) ? clazz.getAnnotation(Qualifier.class).value() : null;
        if (qualifier != null && !"".equals(qualifier)) {
            return qualifier;
        }
        return ClassUtils.getShortNameAsProperty(clazz);
    }

    private class ClassPathScanner
    extends ClassPathScanningCandidateComponentProvider {
        ClassPathScanner() {
            super(false);
        }

        protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
            return beanDefinition.getMetadata().isIndependent();
        }
    }
}

