/*
 * Decompiled with CFR 0.152.
 */
package org.bakeneko.rabbitmq.rpc.factory;

import java.util.regex.Pattern;
import org.bakeneko.rabbitmq.rpc.factory.PropertiesResolver;
import org.springframework.core.env.Environment;
import org.springframework.util.PropertyPlaceholderHelper;

public class PropertiesResolverImpl
implements PropertiesResolver {
    private Environment environment;
    private PropertyPlaceholderHelper propertyPlaceholderHelper = new PropertyPlaceholderHelper("${", "}", ":", true);
    private Pattern propertyReferencePattern = Pattern.compile("^\\$\\{.*}$");

    public PropertiesResolverImpl(Environment environment) {
        this.environment = environment;
    }

    @Override
    public String replaceIfProperty(String value) {
        if (value != null && !value.isEmpty() && this.propertyReferencePattern.matcher(value).matches()) {
            return this.propertyPlaceholderHelper.replacePlaceholders(value, name -> this.environment.getRequiredProperty(name));
        }
        return value;
    }
}

