/*
 * Decompiled with CFR 0.152.
 */
package org.bakeneko.rabbitmq.rpc.factory;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bakeneko.rabbitmq.rpc.RabbitClient;
import org.bakeneko.rabbitmq.rpc.RabbitSender;
import org.bakeneko.rabbitmq.rpc.factory.PropertiesResolver;
import org.bakeneko.rabbitmq.rpc.factory.RabbitClientAnnotationProcessor;
import org.bakeneko.rabbitmq.rpc.factory.RabbitClientMetadata;
import org.bakeneko.rabbitmq.rpc.factory.ReflectionUtils;
import org.springframework.amqp.core.MessagePostProcessor;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.messaging.handler.annotation.Headers;
import org.springframework.messaging.handler.annotation.Payload;

public class RabbitClientAnnotationProcessorImpl
implements RabbitClientAnnotationProcessor {
    private PropertiesResolver propertiesResolver;
    private Map<String, MessagePostProcessor> postProcessors;

    public RabbitClientAnnotationProcessorImpl(PropertiesResolver propertiesResolver, Map<String, MessagePostProcessor> postProcessors) {
        this.propertiesResolver = propertiesResolver;
        this.postProcessors = postProcessors;
    }

    @Override
    public Map<String, RabbitClientMetadata> readMetadata(Class<?> toImplement) {
        if (toImplement.isAnnotationPresent(RabbitClient.class)) {
            RabbitClient rabbitClient = toImplement.getAnnotation(RabbitClient.class);
            String defaultExchange = !rabbitClient.exchange().isEmpty() ? rabbitClient.exchange() : null;
            String defaultRoutingKey = !rabbitClient.routingKey().isEmpty() ? rabbitClient.routingKey() : null;
            MessagePostProcessor defaultMessagePostProcessor = !rabbitClient.messagePostProcessor().isEmpty() ? this.getMessagePostProcessor(rabbitClient.messagePostProcessor()) : null;
            Map<String, Method> methodsByName = Stream.of(toImplement.getDeclaredMethods()).collect(Collectors.toMap(ReflectionUtils::methodNameSignatureAware, m -> m));
            return methodsByName.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
                Method method = (Method)entry.getValue();
                Integer payloadParameterIndex = this.getPayloadParameterIndex(method);
                Integer headerMapParameterIndex = this.getHeaderMapParameterIndex(method);
                Map<String, Integer> headerParameterIndexByName = this.getHeaderParameterIndexByName(method);
                if (method.isAnnotationPresent(RabbitSender.class)) {
                    RabbitSender rabbitSender = method.getAnnotation(RabbitSender.class);
                    String exchange = !rabbitSender.exchange().isEmpty() ? rabbitSender.exchange() : defaultExchange;
                    String routingKey = !rabbitSender.routingKey().isEmpty() ? rabbitSender.routingKey() : defaultRoutingKey;
                    MessagePostProcessor messagePostProcessor = !rabbitSender.messagePostProcessor().isEmpty() ? this.getMessagePostProcessor(rabbitSender.messagePostProcessor()) : defaultMessagePostProcessor;
                    return new RabbitClientMetadata(this.propertiesResolver.replaceIfProperty(exchange), this.propertiesResolver.replaceIfProperty(routingKey), messagePostProcessor, payloadParameterIndex, headerMapParameterIndex, headerParameterIndexByName);
                }
                return new RabbitClientMetadata(this.propertiesResolver.replaceIfProperty(defaultExchange), this.propertiesResolver.replaceIfProperty(defaultRoutingKey), defaultMessagePostProcessor, payloadParameterIndex, headerMapParameterIndex, headerParameterIndexByName);
            }));
        }
        throw new IllegalArgumentException("The class provided is not a @RabbitClient: " + toImplement.getCanonicalName());
    }

    private Integer getPayloadParameterIndex(Method method) {
        if (method.getParameterCount() == 1 && !this.isHeader(method.getParameters()[0])) {
            return 0;
        }
        if (method.getParameterCount() == 0 || method.getParameterCount() == 1 && this.isHeader(method.getParameters()[0])) {
            throw new IllegalStateException(String.format("No @Payload parameters found in %s.%s. At least one @Payload parameter must be present - if a parameter is the only one and not marked as @Header, it's also considered @Payload.", method.getDeclaringClass().getName(), method.getName()));
        }
        for (int i = 0; i < method.getParameterCount(); ++i) {
            if (!this.isPayload(method.getParameters()[i])) continue;
            return i;
        }
        throw new IllegalStateException(String.format("Multiple parameters specified in %s.%s, but none of them is marked as @Payload.", method.getDeclaringClass().getName(), method.getName()));
    }

    private Map<String, Integer> getHeaderParameterIndexByName(Method method) {
        HashMap<String, Integer> indexByName = new HashMap<String, Integer>();
        AtomicInteger i = new AtomicInteger(0);
        while (i.get() < method.getParameterCount()) {
            Stream.of(method.getParameterAnnotations()[i.get()]).filter(it -> it.annotationType().equals(Header.class)).findFirst().ifPresent(annotation -> {
                Header header = (Header)annotation;
                String headerName = !header.value().isEmpty() ? header.value() : (!header.name().isEmpty() ? header.name() : method.getParameters()[i.get()].getName());
                indexByName.put(headerName, i.get());
            });
            i.incrementAndGet();
        }
        return indexByName;
    }

    private Integer getHeaderMapParameterIndex(Method method) {
        long headerMapParameters = Stream.of(method.getParameters()).filter(this::isHeaderMap).count();
        if (headerMapParameters == 1L) {
            for (int i = 0; i < method.getParameterCount(); ++i) {
                if (!this.isHeaderMap(method.getParameters()[i])) continue;
                Class<?> parameterType = method.getParameters()[i].getType();
                if (Map.class.isAssignableFrom(parameterType)) {
                    return i;
                }
                throw new IllegalArgumentException(String.format("Parameters marked as @Headers must be assignable to java.util.Map<String, Object>, while %s.%s has type %s.", method.getDeclaringClass().getName(), method.getName(), parameterType));
            }
        } else if (headerMapParameters > 1L) {
            throw new IllegalStateException(String.format("Multiple @Headers parameters specified in %s.%s, while a maximum of 1 is allowed.", method.getDeclaringClass().getName(), method.getName()));
        }
        return null;
    }

    private boolean isHeader(Parameter parameter) {
        return this.hasAnnotation(parameter, Header.class);
    }

    private boolean isHeaderMap(Parameter parameter) {
        return this.hasAnnotation(parameter, Headers.class);
    }

    private boolean isPayload(Parameter parameter) {
        return this.hasAnnotation(parameter, Payload.class);
    }

    private <T extends Annotation> boolean hasAnnotation(Parameter parameter, Class<T> annotationType) {
        return Stream.of(parameter.getAnnotations()).anyMatch(it -> it.annotationType().equals(annotationType));
    }

    private MessagePostProcessor getMessagePostProcessor(String beanName) {
        if (this.postProcessors.containsKey(beanName)) {
            return this.postProcessors.get(beanName);
        }
        throw this.postProcessorNotFoundException(beanName);
    }

    private IllegalStateException postProcessorNotFoundException(String postProcessorName) {
        return new IllegalStateException("No message post processor bean found with name \"" + postProcessorName + "\", although it is required by a @RabbitClient");
    }
}

