/*
 * Decompiled with CFR 0.152.
 */
package org.bakeneko.rabbitmq.rpc.factory;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Map;
import org.bakeneko.rabbitmq.rpc.RabbitClient;
import org.bakeneko.rabbitmq.rpc.factory.ObjectMethodsDelegatingInvocationHandler;
import org.bakeneko.rabbitmq.rpc.factory.RabbitClientAnnotationProcessor;
import org.bakeneko.rabbitmq.rpc.factory.RabbitClientFactory;
import org.bakeneko.rabbitmq.rpc.factory.RabbitClientMetadata;
import org.bakeneko.rabbitmq.rpc.factory.ReflectionUtils;
import org.springframework.amqp.core.MessagePostProcessor;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.core.ParameterizedTypeReference;

public class RabbitClientFactoryImpl
implements RabbitClientFactory {
    private RabbitClientAnnotationProcessor annotationProcessor;
    private RabbitTemplate rabbitTemplate;

    public RabbitClientFactoryImpl(RabbitTemplate rabbitTemplate, RabbitClientAnnotationProcessor annotationProcessor) {
        this.rabbitTemplate = rabbitTemplate;
        this.annotationProcessor = annotationProcessor;
    }

    @Override
    public <T> T forType(Class<T> toImplement) {
        return this.forType(RabbitClientFactoryImpl.class.getClassLoader(), toImplement);
    }

    @Override
    public <T> T forType(ClassLoader classLoader, Class<T> toImplement) {
        if (toImplement.isAnnotationPresent(RabbitClient.class)) {
            Map<String, RabbitClientMetadata> metadata = this.annotationProcessor.readMetadata(toImplement);
            return (T)Proxy.newProxyInstance(classLoader, new Class[]{toImplement}, (InvocationHandler)new ObjectMethodsDelegatingInvocationHandler(this.invocationHandler(metadata)));
        }
        throw new IllegalArgumentException("The class provided is not a @RabbitClient: " + toImplement.getCanonicalName());
    }

    private InvocationHandler invocationHandler(Map<String, RabbitClientMetadata> metadataByMethod) {
        return (proxy, method, args) -> {
            RabbitClientMetadata metadata = (RabbitClientMetadata)metadataByMethod.get(ReflectionUtils.methodNameSignatureAware(method));
            String exchange = metadata.getExchange();
            String routingKey = metadata.getRoutingKey();
            MessagePostProcessor postProcessor = this.headerAppendingPostProcessorWrapper(metadata.getHeaders(args), metadata.getMessagePostProcessor());
            if ("void".equals(method.getAnnotatedReturnType().getType().getTypeName())) {
                this.sendAsync(exchange, routingKey, metadata.getPayload(args), postProcessor);
                return null;
            }
            return this.sendAndReceive(exchange, routingKey, metadata.getPayload(args), method.getGenericReturnType(), postProcessor);
        };
    }

    private MessagePostProcessor headerAppendingPostProcessorWrapper(Map<String, Object> headers, MessagePostProcessor postProcessor) {
        return message -> {
            headers.forEach((name, value) -> message.getMessageProperties().getHeaders().put(name, value));
            return postProcessor.postProcessMessage(message);
        };
    }

    private <V> V sendAndReceive(String exchange, String routingKey, Object payload, Type returnType, MessagePostProcessor postProcessor) {
        ParameterizedTypeReference returnTypeReference = ParameterizedTypeReference.forType((Type)returnType);
        if (exchange != null) {
            return (V)this.rabbitTemplate.convertSendAndReceiveAsType(exchange, routingKey, payload, postProcessor, returnTypeReference);
        }
        if (routingKey != null) {
            return (V)this.rabbitTemplate.convertSendAndReceiveAsType(routingKey, payload, postProcessor, returnTypeReference);
        }
        return (V)this.rabbitTemplate.convertSendAndReceiveAsType(payload, postProcessor, returnTypeReference);
    }

    private void sendAsync(String exchange, String routingKey, Object payload, MessagePostProcessor postProcessor) {
        if (exchange != null) {
            this.rabbitTemplate.convertAndSend(exchange, routingKey, payload, postProcessor);
        } else if (routingKey != null) {
            this.rabbitTemplate.convertAndSend(routingKey, payload, postProcessor);
        } else {
            this.rabbitTemplate.convertAndSend(payload, postProcessor);
        }
    }
}

