/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.base.datatable;

import com.querydsl.core.types.dsl.ComparableExpression;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.core.types.dsl.StringPath;
import org.bardframework.base.UtilityMethods;
import org.bardframework.base.datatable.DataLimitationChecker;
import org.bardframework.base.datatable.FilteringType;
import org.bardframework.base.datatable.FormulaQueryResolver;
import org.bardframework.base.datatable.HeaderAbstract;
import org.bardframework.base.datatable.QueryType;

public class HeaderQdsl
extends HeaderAbstract {
    private SimpleExpression<?> queryPath;
    private DataLimitationChecker checker;

    public void setQueryPath(Class<?> mainClazz, Class<?> valueType, String fieldName, String tableName, SimpleExpression<?> queryPath) {
        if (this.queryType == QueryType.NONE) {
            if (this.filterType != FilteringType.NONE) {
                LOGGER.error("invalid HeaderAbstract definition on '{}'@'{}', when query type is {}, filtering type must be {}", new Object[]{this.path, mainClazz.getSimpleName(), QueryType.NONE, FilteringType.NONE});
                throw new IllegalStateException("filtering and query type must be NONE or not NONE together");
            }
            this.queryPath = null;
        } else if (this.queryType == QueryType.DB_COLUMN || this.queryType == QueryType.HIERARCHY) {
            this.queryPath = queryPath;
        } else if (this.queryType == QueryType.FORMULA) {
            if (null == FormulaQueryResolver.getQuery(tableName, fieldName)) {
                LOGGER.error("'{}' in '{}' annotated with @HeaderAbstract with '{}' query type, but queryResolver not set.", new Object[]{this.path, mainClazz, QueryType.FORMULA});
                throw new IllegalArgumentException("filed that annotated with @HeaderAbstract with  'FORMULA' query type must set queryResolver.");
            }
            if (this.filterType != FilteringType.MULTI_SELECT && this.filterType != FilteringType.SINGLE_SELECT) {
                LOGGER.error("when choose query type as '{}', only '{}' and '{}' are valid for filtering type.", new Object[]{QueryType.FORMULA, FilteringType.MULTI_SELECT, FilteringType.SINGLE_SELECT});
                throw new IllegalArgumentException("invalid combination of query type and filtering type.");
            }
            if (this.searchable || this.sortable) {
                LOGGER.error("'{}' in '{}' annotated with @HeaderAbstract with '{}' type, can't be searchable, sortable", new Object[]{this.path, mainClazz, QueryType.FORMULA});
                throw new IllegalArgumentException("filed annotated with @HeaderAbstract with 'ENUM' type, can't be searchable or sortable");
            }
            this.checker = new DataLimitationChecker(valueType);
            this.queryPath = null;
        }
    }

    public void init(Class<?> mainClazz, Class<?> valueType, String fieldName, String tableName, SimpleExpression<?> queryPath) {
        this.validate(mainClazz);
        this.determineConverters(valueType);
        this.setQueryPath(mainClazz, valueType, fieldName, tableName, queryPath);
        this.messageKeys = UtilityMethods.toMessageKeys((String)(mainClazz.getSimpleName() + "." + this.path));
    }

    public <T extends Comparable> ComparableExpression<T> getMinMaxPath() {
        return (ComparableExpression)this.queryPath;
    }

    public SimpleExpression<?> getQueryPath() {
        return this.queryPath;
    }

    public StringPath getSearchPath() {
        return (StringPath)this.queryPath;
    }

    public DataLimitationChecker getChecker() {
        return this.checker;
    }
}

