/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.crud.impl.querydsl.base;

import com.querydsl.core.dml.StoreClause;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.ComparableExpressionBase;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.sql.RelationalPathBase;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.SQLQueryFactory;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.bardframework.commons.utils.AssertionUtils;
import org.bardframework.commons.utils.ReflectionUtils;
import org.bardframework.crud.api.base.BaseCriteria;
import org.bardframework.crud.api.base.BaseModel;
import org.bardframework.crud.api.base.BaseRepository;
import org.bardframework.crud.api.base.PagedData;
import org.bardframework.crud.impl.querydsl.base.ReadExtendedRepositoryQdslSql;
import org.bardframework.crud.impl.querydsl.base.SaveExtendedRepositoryQdslSql;
import org.bardframework.crud.impl.querydsl.base.UpdateExtendedRepositoryQdslSql;
import org.bardframework.crud.impl.querydsl.utils.QueryDslUtils;
import org.bardframework.form.model.filter.IdFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.lang.Nullable;
import org.springframework.transaction.annotation.Transactional;

public abstract class BaseRepositoryQdslSqlAbstract<M extends BaseModel<I>, C extends BaseCriteria<I>, I extends Serializable, U>
implements BaseRepository<M, C, I, U> {
    private static final int DEFAULT_SIZE = 20;
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    protected final Class<M> modelClazz;
    protected final Class<C> criteriaClazz;
    protected final Class<I> idClazz;
    private final SQLQueryFactory queryFactory;

    public BaseRepositoryQdslSqlAbstract(SQLQueryFactory queryFactory) {
        this.queryFactory = queryFactory;
        this.modelClazz = ReflectionUtils.getGenericArgType(this.getClass(), (int)0);
        this.criteriaClazz = ReflectionUtils.getGenericArgType(this.getClass(), (int)1);
        this.idClazz = ReflectionUtils.getGenericArgType(this.getClass(), (int)2);
    }

    protected abstract <T extends StoreClause<T>> void onSave(T var1, M var2, U var3);

    protected abstract <T extends StoreClause<T>> void onUpdate(T var1, M var2, U var3);

    protected abstract Predicate getPredicate(C var1, U var2);

    protected abstract RelationalPathBase<?> getEntity();

    protected abstract Expression<M> getSelectExpression();

    protected abstract Expression<I> getIdSelectExpression();

    protected abstract I generateId(M var1, U var2);

    protected Predicate getPredicate(IdFilter<I> idFilter, U user) {
        if (!(this.getIdSelectExpression() instanceof SimpleExpression)) {
            throw new IllegalStateException("can't construct Predicate for IdFilter, getIdSelectExpression is not instance of SimpleExpression, override getPredicate(IdFilter, U) and implement it.");
        }
        return QueryDslUtils.getPredicate(idFilter, (SimpleExpression)this.getIdSelectExpression());
    }

    @Transactional
    public M save(M model, U user) {
        AssertionUtils.notNull(model, (String)"Given model cannot be null.");
        return (M)((BaseModel)this.save((Collection<M>)Collections.singletonList(model), user).get(0));
    }

    @Transactional
    public List<M> save(Collection<M> models, U user) {
        Long affectedCount;
        AssertionUtils.notNull(models, (String)"Given models cannot be null.");
        if (CollectionUtils.isEmpty(models)) {
            return Collections.emptyList();
        }
        ArrayList<M> list = new ArrayList<M>(models);
        SQLInsertClause insertClause = this.getQueryFactory().insert(this.getEntity());
        list.forEach(model -> {
            model.setId(this.generateId(model, user));
            this.onSaveInternal(insertClause, model, user);
            insertClause.addBatch();
        });
        if (this.getIdSelectExpression() instanceof Path) {
            List generatedIds = insertClause.executeWithKeys((Path)this.getIdSelectExpression());
            if (CollectionUtils.isNotEmpty((Collection)generatedIds)) {
                for (int i = 0; i < list.size(); ++i) {
                    ((BaseModel)list.get(i)).setId((Serializable)generatedIds.get(i));
                }
            }
            affectedCount = CollectionUtils.isNotEmpty((Collection)generatedIds) ? Long.valueOf(generatedIds.size()) : null;
        } else {
            affectedCount = insertClause.execute();
        }
        if (null != affectedCount && (long)list.size() != affectedCount) {
            this.LOGGER.warn("expect insert '{}' row, but '{}' row(s) inserted.", (Object)list.size(), (Object)affectedCount);
        }
        return list;
    }

    @Transactional
    public M update(M model, U user) {
        AssertionUtils.notNull(model, (String)"model cannot be null.");
        return (M)((BaseModel)this.update((Collection<M>)Collections.singletonList(model), user).get(0));
    }

    @Transactional
    public List<M> update(Collection<M> models, U user) {
        AssertionUtils.notNull(models, (String)"Given models cannot be null.");
        if (CollectionUtils.isEmpty(models)) {
            return Collections.emptyList();
        }
        SQLUpdateClause updateClause = this.getQueryFactory().update(this.getEntity());
        models.forEach(model -> {
            AssertionUtils.notNull((Object)model.getId(), (String)"model identifier is not provided, can't update");
            updateClause.where(this.getPredicate((IdFilter)new IdFilter().setEquals((Object)model.getId()), user));
            this.onUpdateInternal(updateClause, model, user);
            updateClause.addBatch();
        });
        long affectedRowsCount = updateClause.execute();
        if ((long)models.size() != affectedRowsCount) {
            this.LOGGER.error("expect update '{}' row, but '{}' row(s) updated.", (Object)models.size(), (Object)affectedRowsCount);
            throw new IllegalStateException("affected rows in update not valid");
        }
        return new ArrayList<M>(models);
    }

    @Transactional
    public M patch(I id, Map<String, Object> patch, U user) {
        AssertionUtils.notNull(id, (String)"id cannot be null.");
        AssertionUtils.notEmpty(patch, (String)"patch cannot be empty.");
        SQLUpdateClause updateClause = this.getQueryFactory().update(this.getEntity());
        updateClause.where(this.getPredicate((IdFilter)new IdFilter().setEquals(id), user));
        for (Map.Entry<String, Object> entry : patch.entrySet()) {
            Path<?> path = this.getPath(entry.getKey());
            if (null == entry.getValue()) {
                updateClause.setNull(path);
                continue;
            }
            updateClause.set(path, entry.getValue());
        }
        long affectedRowsCount = updateClause.execute();
        if (1L != affectedRowsCount) {
            throw new IllegalStateException("expect affect one row, but " + affectedRowsCount + " row(s) updated.");
        }
        return this.get(id, user);
    }

    @Transactional(readOnly=true)
    public M get(I id, U user) {
        AssertionUtils.notNull(id, (String)"Given id cannot be null.");
        BaseCriteria criteria = (BaseCriteria)ReflectionUtils.newInstance(this.criteriaClazz);
        criteria.setIdFilter((IdFilter)new IdFilter().setEquals(id));
        return this.getOne(criteria, user);
    }

    @Transactional(readOnly=true)
    public List<M> get(Collection<I> ids, U user) {
        AssertionUtils.notEmpty(ids, (String)"Given ids cannot be empty.");
        BaseCriteria criteria = (BaseCriteria)ReflectionUtils.newInstance(this.criteriaClazz);
        criteria.setIdFilter((IdFilter)new IdFilter().setIn(ids));
        return this.get((C)criteria, user);
    }

    @Transactional(readOnly=true)
    public PagedData<M> get(C criteria, Pageable pageable, U user) {
        AssertionUtils.notNull(criteria, (String)"Given criteria cannot be null.");
        AssertionUtils.notNull((Object)pageable, (String)"Given pageable cannot be null.");
        SQLQuery query = this.prepareSelectQuery(criteria, user);
        this.setOrders(query, pageable.getSort());
        long total = query.fetchCount();
        if (0L >= total) {
            return new PagedData();
        }
        query = query.clone(this.getQueryFactory().getConnection());
        if (pageable.getPageSize() == 0) {
            query.offset((long)Math.max(pageable.getPageNumber(), 0) * 20L);
            query.limit(20L);
        } else {
            query.offset(pageable.getOffset());
            query.limit((long)pageable.getPageSize());
        }
        List result = query.select(this.getSelectExpression()).fetch();
        return new PagedData(result, total);
    }

    @Transactional(readOnly=true)
    public long getCount(C criteria, U user) {
        AssertionUtils.notNull(criteria, (String)"Given criteria cannot be null.");
        return this.prepareSelectQuery(criteria, user).fetchCount();
    }

    @Transactional(readOnly=true)
    public boolean isExist(C criteria, U user) {
        return this.getCount(criteria, user) > 0L;
    }

    @Transactional(readOnly=true)
    public boolean isNotExist(C criteria, U user) {
        return this.getCount(criteria, user) == 0L;
    }

    @Transactional
    public long delete(I id, U user) {
        AssertionUtils.notNull(id, (String)"id should not be null.");
        return this.delete((C)Collections.singletonList(id), user);
    }

    @Transactional
    public long delete(Collection<I> ids, U user) {
        AssertionUtils.notEmpty(ids, (String)"Given ids cannot be null.");
        BaseCriteria criteria = (BaseCriteria)ReflectionUtils.newInstance(this.criteriaClazz);
        criteria.setIdFilter((IdFilter)new IdFilter().setIn(ids));
        return this.delete((C)criteria, user);
    }

    @Transactional
    public long delete(C criteria, U user) {
        AssertionUtils.notNull(criteria, (String)"Criteria object should not be null.");
        SQLDeleteClause deleteClause = this.getQueryFactory().delete(this.getEntity());
        deleteClause.where(this.getPredicate(criteria.getIdFilter(), user));
        deleteClause.where(this.getPredicate(criteria, user));
        return deleteClause.execute();
    }

    @Transactional(readOnly=true)
    public List<I> getIds(C criteria, U user) {
        AssertionUtils.notNull(criteria, (String)"Given criteria cannot be null.");
        return this.prepareSelectQuery(criteria, user).select(this.getIdSelectExpression()).fetch();
    }

    @Transactional(readOnly=true)
    public List<M> get(C criteria, U user) {
        return this.get(criteria, (Sort)null, user);
    }

    @Transactional(readOnly=true)
    public List<M> get(C criteria, Sort sort, U user) {
        AssertionUtils.notNull(criteria, (String)"Given criteria cannot be null");
        SQLQuery<?> sqlQuery = this.prepareSelectQuery(criteria, user);
        this.setOrders(sqlQuery, sort);
        return sqlQuery.select(this.getSelectExpression()).fetch();
    }

    @Transactional(readOnly=true)
    public M getOne(C criteria, U user) {
        AssertionUtils.notNull(criteria, (String)"Given criteria cannot be null");
        return (M)((BaseModel)this.prepareSelectQuery(criteria, user).select(this.getSelectExpression()).fetchOne());
    }

    private <T extends StoreClause<T>> void onSaveInternal(T clause, M model, U user) {
        this.onSave(clause, model, user);
        for (Class<?> clazz : this.getClass().getInterfaces()) {
            if (!SaveExtendedRepositoryQdslSql.class.isAssignableFrom(clazz)) continue;
            ((SaveExtendedRepositoryQdslSql)((Object)this)).onSave(clause, model, user);
        }
    }

    private <T extends StoreClause<T>> void onUpdateInternal(T clause, M model, U user) {
        this.onUpdate(clause, model, user);
        for (Class<?> clazz : this.getClass().getInterfaces()) {
            if (!UpdateExtendedRepositoryQdslSql.class.isAssignableFrom(clazz)) continue;
            ((UpdateExtendedRepositoryQdslSql)((Object)this)).onUpdate(clause, model, user);
        }
    }

    private SQLQuery<?> prepareSelectQuery(C criteria, U user) {
        SQLQuery query = (SQLQuery)this.getQueryFactory().query().from(this.getEntity());
        query.where(this.getPredicate(criteria.getIdFilter(), user));
        query.where(this.getPredicate(criteria, user));
        for (Class<?> clazz : this.getClass().getInterfaces()) {
            if (!ReadExtendedRepositoryQdslSql.class.isAssignableFrom(clazz)) continue;
            ((ReadExtendedRepositoryQdslSql)((Object)this)).process(criteria, query, user);
        }
        this.setSelectJoins(query, criteria, user);
        return query;
    }

    private OrderSpecifier<?> toOrderSpecifier(Sort.Order order) {
        ComparableExpressionBase column = (ComparableExpressionBase)this.getPath(order.getProperty());
        return order.isAscending() ? column.asc() : column.desc();
    }

    private Path<?> getPath(String columnName) {
        List columns = this.getEntity().getColumns();
        for (Path column : columns) {
            if (!column.getMetadata().getName().equals(columnName)) continue;
            return column;
        }
        throw new IllegalStateException(String.format("column[%s] not found in entity[%s] ", columnName, this.getEntity().getTableName()));
    }

    protected void setSelectJoins(SQLQuery<?> query, C criteria, U user) {
    }

    protected void setOrders(SQLQuery<?> query, @Nullable Sort sort) {
        if (null == sort || sort.isEmpty()) {
            if (CollectionUtils.isNotEmpty(this.getDefaultOrders())) {
                query.orderBy(this.getDefaultOrders().toArray(new OrderSpecifier[0]));
            }
            return;
        }
        query.orderBy((OrderSpecifier[])sort.stream().map(this::toOrderSpecifier).toArray(OrderSpecifier[]::new));
    }

    protected SQLQueryFactory getQueryFactory() {
        return this.queryFactory;
    }

    protected List<OrderSpecifier<?>> getDefaultOrders() {
        return List.of();
    }
}

