/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.crud.impl.querydsl.searchable;

import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.StringPath;
import com.querydsl.sql.SQLQuery;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.bardframework.commons.utils.ReflectionUtils;
import org.bardframework.crud.api.base.BaseCriteria;
import org.bardframework.crud.api.base.BaseModel;
import org.bardframework.crud.api.searchable.SearchableCriteria;
import org.bardframework.crud.api.searchable.SearchableEntityRepository;
import org.bardframework.crud.impl.querydsl.base.ReadExtendedRepositoryQdslSql;
import org.springframework.data.domain.Pageable;
import org.springframework.transaction.annotation.Transactional;

public interface SearchableEntityRepositoryQdslSql<M extends BaseModel<I>, C extends BaseCriteria<I> & SearchableCriteria, I extends Serializable, U>
extends SearchableEntityRepository<M, C, I, U>,
ReadExtendedRepositoryQdslSql<C, I, U> {
    public StringPath[] getSearchPaths();

    public M getEmptyModel();

    public Path<?> getIdentifierPath();

    public <T> SQLQuery<T> setPageAndSize(SQLQuery<T> var1, Pageable var2, U var3);

    public SQLQuery<?> prepareQuery(C var1, U var2);

    @Transactional(readOnly=true)
    default public List<M> search(C criteria, Pageable pageable, U user) {
        List<Path<?>> selectPaths = this.getSelectOnSearchPaths();
        selectPaths.add(this.getIdentifierPath());
        SQLQuery query = this.prepareQuery(criteria, user).select((Expression[])selectPaths.toArray(new Path[0]));
        this.setPageAndSize(query, pageable, user);
        ArrayList<M> models = new ArrayList<M>();
        for (Tuple tuple : query.fetch()) {
            M model = this.getEmptyModel();
            for (Path<?> searchPath : selectPaths) {
                try {
                    ReflectionUtils.setValue(model, (String)this.getStringPath(searchPath), (Object)tuple.get(searchPath));
                }
                catch (Exception e) {
                    throw new IllegalStateException("can't set value", e);
                }
            }
            models.add(model);
        }
        return models;
    }

    default public List<Path<?>> getSelectOnSearchPaths() {
        return new ArrayList<StringPath>(Arrays.asList(this.getSearchPaths()));
    }

    default public String getStringPath(Path<?> path) {
        Object stringPath = path.getMetadata().getElement().toString();
        if (!path.getRoot().equals(path.getMetadata().getParent())) {
            stringPath = Objects.requireNonNull(path.getMetadata().getParent()).getMetadata().getElement() + "." + (String)stringPath;
        }
        return stringPath;
    }

    @Override
    default public <T> SQLQuery<T> process(C criteria, SQLQuery<T> query, U user) {
        if (StringUtils.isBlank((CharSequence)((SearchableCriteria)criteria).getQuery())) {
            return query;
        }
        BooleanExpression searchExpression = this.getSearchPaths()[0].like("%" + ((SearchableCriteria)criteria).getQuery() + "%", ' ');
        for (int i = 1; i < this.getSearchPaths().length; ++i) {
            searchExpression = searchExpression.or((Predicate)this.getSearchPaths()[i].like("%" + ((SearchableCriteria)criteria).getQuery() + "%", ' '));
        }
        query.where((Predicate)searchExpression);
        return query;
    }
}

