/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.crud.impl.querydsl.utils;

import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.dsl.ComparableExpression;
import com.querydsl.core.types.dsl.NumberExpression;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.core.types.dsl.StringPath;
import java.io.Serializable;
import java.util.Collection;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.bardframework.form.model.filter.Filter;
import org.bardframework.form.model.filter.NumberRangeFilter;
import org.bardframework.form.model.filter.RangeFilter;
import org.bardframework.form.model.filter.StringFilter;

public final class QueryDslUtils {
    private QueryDslUtils() {
    }

    public static <T> Expression<T> bean(String alias, Class<T> type, Expression<?> ... expressions) {
        return ExpressionUtils.as((Expression)Projections.bean(type, expressions).skipNulls(), (String)alias);
    }

    public static <T> QBean<T> bean(Class<T> type, Expression<?> ... expressions) {
        return Projections.bean(type, expressions);
    }

    public static Predicate getPredicate(StringFilter filter, StringPath path) {
        if (null == filter) {
            return null;
        }
        BooleanBuilder builder = new BooleanBuilder(QueryDslUtils.getPredicate(filter, path));
        if (StringUtils.isNotBlank((CharSequence)filter.getContains())) {
            builder.and((Predicate)path.likeIgnoreCase("%" + filter.getContains() + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)filter.getDoesNotContain())) {
            builder.and((Predicate)path.notLike("%" + filter.getDoesNotContain() + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)filter.getStartWith())) {
            builder.and((Predicate)path.likeIgnoreCase(filter.getStartWith() + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)filter.getEndWith())) {
            builder.and((Predicate)path.notLike("%" + filter.getDoesNotContain()));
        }
        return builder;
    }

    public static <T extends Number, F extends NumberRangeFilter<T, F>> Predicate getPredicate(NumberRangeFilter<T, F> filter, NumberExpression<T> path) {
        if (null == filter) {
            return null;
        }
        BooleanBuilder builder = new BooleanBuilder(QueryDslUtils.getPredicate(filter, path));
        if (filter.getFrom() != null) {
            builder.and((Predicate)path.goe((Number)filter.getFrom()));
        }
        if (filter.getTo() != null) {
            builder.and((Predicate)path.loe((Number)filter.getTo()));
        }
        return builder;
    }

    public static <T extends Comparable<?> & Serializable> Predicate getPredicate(RangeFilter<T, ?> filter, ComparableExpression<T> path) {
        if (null == filter) {
            return null;
        }
        BooleanBuilder builder = new BooleanBuilder(QueryDslUtils.getPredicate(filter, path));
        if (filter.getFrom() != null) {
            builder.and((Predicate)path.goe((Comparable)((Object)filter.getFrom())));
        }
        if (filter.getTo() != null) {
            builder.and((Predicate)path.loe((Comparable)((Object)filter.getTo())));
        }
        return builder;
    }

    public static <I extends Serializable> Predicate getPredicate(Filter<I, ?> filter, SimpleExpression<I> path) {
        return QueryDslUtils.getPredicate(filter, arg_0 -> path.eq(arg_0), () -> path.isNotNull(), () -> path.isNull());
    }

    public static <I extends Serializable> Predicate getPredicate(Filter<I, ?> filter, Function<I, Predicate> equals, Supplier<Predicate> isNotNull, Supplier<Predicate> isNull) {
        if (null == filter) {
            return null;
        }
        BooleanBuilder builder = new BooleanBuilder();
        if (null != filter.getEquals()) {
            builder.and(equals.apply((Serializable)filter.getEquals()));
        }
        if (null != filter.getNotEquals()) {
            builder.and(equals.apply((Serializable)filter.getNotEquals()).not());
        }
        if (CollectionUtils.isNotEmpty((Collection)filter.getIn())) {
            BooleanBuilder inBuilder = new BooleanBuilder();
            for (Serializable id : filter.getIn()) {
                inBuilder.or(equals.apply(id));
            }
            builder.and((Predicate)inBuilder);
        }
        if (CollectionUtils.isNotEmpty((Collection)filter.getNotIn())) {
            BooleanBuilder notInBuilder = new BooleanBuilder();
            for (Serializable id : filter.getNotIn()) {
                notInBuilder.or(equals.apply(id));
            }
            builder.and((Predicate)notInBuilder.not());
        }
        if (filter.getSpecified() != null) {
            if (filter.getSpecified().booleanValue()) {
                builder.and(isNotNull.get());
            } else {
                builder.and(isNull.get());
            }
        }
        return builder;
    }
}

