/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.crud.impl.querydsl.base;

import com.querydsl.core.FetchableQuery;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.ComparableExpressionBase;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.sql.ProjectableSQLQuery;
import com.querydsl.sql.RelationalPathBase;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.SQLQueryFactory;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.bardframework.commons.utils.AssertionUtils;
import org.bardframework.commons.utils.ReflectionUtils;
import org.bardframework.crud.api.base.BaseCriteria;
import org.bardframework.crud.api.base.BaseModel;
import org.bardframework.crud.api.base.PagedData;
import org.bardframework.crud.api.base.ReadRepository;
import org.bardframework.crud.exception.InvalidFieldException;
import org.bardframework.crud.impl.querydsl.base.ReadExtendedRepositoryQdslSql;
import org.bardframework.crud.impl.querydsl.utils.QueryDslUtils;
import org.bardframework.form.model.filter.IdFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.lang.Nullable;
import org.springframework.transaction.annotation.Transactional;

public abstract class ReadRepositoryQdslSqlAbstract<M extends BaseModel<I>, C extends BaseCriteria<I>, I, U>
implements ReadRepository<M, C, I, U> {
    protected final SQLQueryFactory queryFactory;
    protected final Class<M> modelClazz;
    protected final Class<C> criteriaClazz;
    protected final Class<I> idClazz;
    protected final Map<String, Path<?>> columns;
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    public ReadRepositoryQdslSqlAbstract(SQLQueryFactory queryFactory) {
        this.queryFactory = queryFactory;
        this.modelClazz = ReflectionUtils.getGenericArgType(this.getClass(), (int)0);
        this.criteriaClazz = ReflectionUtils.getGenericArgType(this.getClass(), (int)1);
        this.idClazz = ReflectionUtils.getGenericArgType(this.getClass(), (int)2);
        this.columns = this.getEntity().getColumns().stream().collect(Collectors.toMap(path -> path.getMetadata().getName(), Function.identity()));
    }

    protected abstract Predicate getPredicate(C var1, U var2);

    protected abstract RelationalPathBase<?> getEntity();

    protected abstract Expression<M> getSelectExpression();

    protected abstract Expression<I> getIdSelectExpression();

    protected Predicate getPredicate(IdFilter<I> idFilter, U user) {
        if (!(this.getIdSelectExpression() instanceof SimpleExpression)) {
            throw new IllegalStateException("can't construct Predicate for IdFilter, getIdSelectExpression is not instance of SimpleExpression, override getPredicate(IdFilter, U) and implement it.");
        }
        return QueryDslUtils.getPredicate(idFilter, (SimpleExpression)this.getIdSelectExpression());
    }

    @Transactional(readOnly=true)
    public M get(I id, U user) {
        AssertionUtils.notNull(id, (String)"Given id cannot be null.");
        BaseCriteria criteria = (BaseCriteria)ReflectionUtils.newInstance(this.criteriaClazz);
        criteria.setIdFilter((IdFilter)new IdFilter().setEquals(id));
        return this.getOne(criteria, user);
    }

    @Transactional(readOnly=true)
    public List<M> get(Collection<I> ids, U user) {
        AssertionUtils.notEmpty(ids, (String)"Given ids cannot be empty.");
        BaseCriteria criteria = (BaseCriteria)ReflectionUtils.newInstance(this.criteriaClazz);
        criteria.setIdFilter((IdFilter)new IdFilter().setIn(ids));
        return this.get((C)criteria, user);
    }

    @Transactional(readOnly=true)
    public PagedData<M> get(C criteria, Pageable pageable, U user) {
        AssertionUtils.notNull(criteria, (String)"Given criteria cannot be null.");
        AssertionUtils.notNull((Object)pageable, (String)"Given pageable cannot be null.");
        SQLQuery query = this.prepareSelectQuery(criteria, user);
        long total = query.fetchCount();
        if (0L >= total) {
            return new PagedData();
        }
        this.setOrders(query, pageable.getSort());
        query = query.clone(this.getQueryFactory().getConnection());
        query.offset((long)(pageable.getPageNumber() - 1) * (long)pageable.getPageSize());
        query.limit((long)pageable.getPageSize());
        List result = query.select(this.getSelectExpression()).fetch();
        return new PagedData(result, total);
    }

    @Transactional(readOnly=true)
    public List<I> getIds(C criteria, Pageable pageable, U user) {
        SQLQuery<?> query = this.prepareSelectQuery(criteria, user);
        this.setOrders(query, pageable.getSort());
        query.offset((long)(pageable.getPageNumber() - 1) * (long)pageable.getPageSize());
        query.limit((long)pageable.getPageSize());
        return query.select(this.getIdSelectExpression()).fetch();
    }

    @Transactional(readOnly=true)
    public M getFirst(C criteria, U user) {
        AssertionUtils.notNull(criteria, (String)"Given criteria cannot be null");
        return (M)((BaseModel)this.prepareSelectQuery(criteria, user).select(this.getSelectExpression()).fetchFirst());
    }

    @Transactional(readOnly=true)
    public M getFirst(C criteria, Sort sort, U user) {
        AssertionUtils.notNull(criteria, (String)"Given criteria cannot be null");
        SQLQuery sqlQuery = this.prepareSelectQuery(criteria, user).select(this.getSelectExpression());
        this.setOrders(sqlQuery, sort);
        return (M)((BaseModel)sqlQuery.fetchFirst());
    }

    @Transactional(readOnly=true)
    public long getCount(C criteria, U user) {
        AssertionUtils.notNull(criteria, (String)"Given criteria cannot be null.");
        return this.prepareSelectQuery(criteria, user).fetchCount();
    }

    @Transactional(readOnly=true)
    public boolean isExist(C criteria, U user) {
        return this.getCount(criteria, user) > 0L;
    }

    @Transactional(readOnly=true)
    public boolean isNotExist(C criteria, U user) {
        return this.getCount(criteria, user) == 0L;
    }

    @Transactional(readOnly=true)
    public List<I> getIds(C criteria, U user) {
        AssertionUtils.notNull(criteria, (String)"Given criteria cannot be null.");
        return this.prepareSelectQuery(criteria, user).select(this.getIdSelectExpression()).fetch();
    }

    @Transactional(readOnly=true)
    public List<M> get(C criteria, U user) {
        return this.getList(criteria, null, user);
    }

    @Transactional(readOnly=true)
    public List<M> getList(C criteria, Pageable pageable, U user) {
        AssertionUtils.notNull(criteria, (String)"Given criteria cannot be null.");
        SQLQuery<?> query = this.prepareSelectQuery(criteria, user);
        if (null != pageable) {
            this.setOrders(query, pageable.getSort());
            if (pageable.isPaged()) {
                query.offset((long)(pageable.getPageNumber() - 1) * (long)pageable.getPageSize());
                query.limit((long)pageable.getPageSize());
            }
        }
        return query.select(this.getSelectExpression()).fetch();
    }

    @Transactional(readOnly=true)
    public M getOne(C criteria, U user) {
        AssertionUtils.notNull(criteria, (String)"Given criteria cannot be null");
        return (M)((BaseModel)this.prepareSelectQuery(criteria, user).select(this.getSelectExpression()).fetchOne());
    }

    @Transactional(readOnly=true)
    public List<M> getList(C criteria, Pageable pageable, List<String> fields, U user) {
        Expression<M> selectExpression;
        AssertionUtils.notNull(criteria, (String)"Given criteria cannot be null.");
        SQLQuery<?> query = this.prepareSelectQuery(criteria, user);
        if (null != pageable) {
            this.setOrders(query, pageable.getSort());
            if (pageable.isPaged()) {
                query.offset((long)(pageable.getPageNumber() - 1) * (long)pageable.getPageSize());
                query.limit((long)pageable.getPageSize());
            }
        }
        if (CollectionUtils.isNotEmpty(fields)) {
            Expression[] expressions = new Expression[fields.size()];
            for (int i = 0; i < fields.size(); ++i) {
                Path<?> path = this.getPath(fields.get(i));
                if (null == path) {
                    throw new InvalidFieldException(fields.get(i));
                }
                expressions[i] = path;
            }
            selectExpression = QueryDslUtils.bean(this.modelClazz, expressions);
        } else {
            selectExpression = this.getSelectExpression();
        }
        return query.select(selectExpression).fetch();
    }

    protected SQLQuery<?> prepareSelectQuery(C criteria, U user) {
        SQLQuery query = (SQLQuery)this.getQueryFactory().query().from(this.getEntity());
        query.where(this.getPredicate(criteria.getIdFilter(), user));
        query.where(this.getPredicate(criteria, user));
        for (Class<?> clazz : this.getClass().getInterfaces()) {
            if (!ReadExtendedRepositoryQdslSql.class.isAssignableFrom(clazz)) continue;
            ((ReadExtendedRepositoryQdslSql)((Object)this)).process(criteria, (FetchableQuery<?, ?>)query, user);
        }
        this.setSelectJoins((ProjectableSQLQuery<?, ?>)query, criteria, user);
        return query;
    }

    protected OrderSpecifier<?> toOrderSpecifier(Sort.Order order) {
        Path<?> path = this.getPath(order.getProperty());
        if (null == path) {
            this.log.warn("column not found for property [{}] to set order.", (Object)order.getProperty());
            return null;
        }
        if (path instanceof ComparableExpressionBase) {
            ComparableExpressionBase column = (ComparableExpressionBase)path;
            return order.isAscending() ? column.asc() : column.desc();
        }
        this.log.warn("column[{}] of property [{}] is not comparable, can't set order.", (Object)path.getClass().getSimpleName(), (Object)order.getProperty());
        return null;
    }

    protected Path<?> getPath(String columnName) {
        return this.columns.get(columnName);
    }

    protected void setSelectJoins(ProjectableSQLQuery<?, ?> query, C criteria, U user) {
    }

    protected void setOrders(SQLQuery<?> query, @Nullable Sort sort) {
        if (null == sort || sort.isEmpty()) {
            return;
        }
        query.orderBy((OrderSpecifier[])sort.stream().map(this::toOrderSpecifier).filter(Objects::nonNull).toArray(OrderSpecifier[]::new));
    }

    protected SQLQueryFactory getQueryFactory() {
        return this.queryFactory;
    }
}

