/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.crud.impl.querydsl.type;

import com.querydsl.sql.types.EnumByNameType;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.lang3.EnumUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EnumByNameTypeSafe<T extends Enum<T>>
extends EnumByNameType<T> {
    private static final Logger log = LoggerFactory.getLogger(EnumByNameTypeSafe.class);
    private final List<T> enumsList = EnumUtils.getEnumList((Class)this.getReturnedClass());

    public EnumByNameTypeSafe(Class<T> type) {
        super(type);
    }

    public EnumByNameTypeSafe(int jdbcType, Class<T> type) {
        super(jdbcType, type);
    }

    public T getValue(ResultSet resultSet, int startIndex) throws SQLException {
        String value = resultSet.getString(startIndex);
        try {
            return value != null ? (T)Enum.valueOf(this.getReturnedClass(), value) : null;
        }
        catch (Exception e) {
            log.error("error converting value[{}] to enum [{}], valid values are: {}", new Object[]{value, this.getReturnedClass(), this.enumsList, e});
            return this.getValueOnConvertError();
        }
    }

    protected abstract T getValueOnConvertError();
}

