/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.crud.impl.querydsl.base;

import com.querydsl.core.dml.StoreClause;
import com.querydsl.core.types.Path;
import com.querydsl.sql.SQLQueryFactory;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.commons.collections4.CollectionUtils;
import org.bardframework.commons.utils.AssertionUtils;
import org.bardframework.commons.utils.ReflectionUtils;
import org.bardframework.crud.api.base.BaseCriteria;
import org.bardframework.crud.api.base.BaseModel;
import org.bardframework.crud.api.base.BaseRepository;
import org.bardframework.crud.impl.querydsl.base.ReadRepositoryQdslSqlAbstract;
import org.bardframework.crud.impl.querydsl.base.SaveExtendedRepositoryQdslSql;
import org.bardframework.crud.impl.querydsl.base.UpdateExtendedRepositoryQdslSql;
import org.bardframework.form.model.filter.IdFilter;
import org.springframework.transaction.annotation.Transactional;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public abstract class BaseRepositoryQdslSqlAbstract<M extends BaseModel<I>, C extends BaseCriteria<I>, I, U>
extends ReadRepositoryQdslSqlAbstract<M, C, I, U>
implements BaseRepository<M, C, I, U> {
    public BaseRepositoryQdslSqlAbstract(SQLQueryFactory queryFactory) {
        super(queryFactory);
    }

    protected abstract <T extends StoreClause<T>> void onSave(T var1, M var2, U var3);

    protected abstract <T extends StoreClause<T>> void onUpdate(T var1, M var2, U var3);

    protected abstract I generateId(M var1, U var2);

    @Transactional
    public M save(M model, U user) {
        AssertionUtils.notNull(model, (String)"Given model cannot be null.");
        return (M)((BaseModel)this.save((Collection<M>)Collections.singletonList(model), user).get(0));
    }

    @Transactional
    public List<M> save(Collection<M> models, U user) {
        AssertionUtils.notNull(models, (String)"Given models cannot be null.");
        if (CollectionUtils.isEmpty(models)) {
            return Collections.emptyList();
        }
        ArrayList<M> list = new ArrayList<M>(models);
        SQLInsertClause insertClause = this.getQueryFactory().insert(this.getEntity());
        this.setIds(list, user);
        list.forEach(model -> {
            this.onSaveInternal(insertClause, model, user);
            insertClause.addBatch();
        });
        Long affectedCount = this.insertAndSetIds(list, insertClause);
        if (null != affectedCount && (long)list.size() != affectedCount) {
            this.log.debug("expect insert '{}' row, but '{}' row(s) inserted.", (Object)list.size(), (Object)affectedCount);
        }
        return list;
    }

    protected void setIds(List<M> list, U user) {
        list.forEach(model -> model.setId(this.generateId(model, user)));
    }

    protected Long insertAndSetIds(List<M> list, SQLInsertClause insertClause) {
        if (!(this.getIdSelectExpression() instanceof Path)) {
            return insertClause.execute();
        }
        List<I> generatedIds = this.insert(insertClause);
        if (CollectionUtils.isNotEmpty(generatedIds)) {
            for (int i = 0; i < list.size(); ++i) {
                ((BaseModel)list.get(i)).setId(generatedIds.get(i));
            }
        }
        return CollectionUtils.isNotEmpty(generatedIds) ? Long.valueOf(generatedIds.size()) : null;
    }

    protected List<I> insert(SQLInsertClause insertClause) {
        return insertClause.executeWithKeys((Path)this.getIdSelectExpression());
    }

    @Transactional
    public M update(M model, U user) {
        AssertionUtils.notNull(model, (String)"model cannot be null.");
        return (M)((BaseModel)this.update((Collection<M>)Collections.singletonList(model), user).get(0));
    }

    @Transactional
    public List<M> update(Collection<M> models, U user) {
        AssertionUtils.notNull(models, (String)"Given models cannot be null.");
        if (CollectionUtils.isEmpty(models)) {
            return Collections.emptyList();
        }
        SQLUpdateClause updateClause = this.getQueryFactory().update(this.getEntity());
        for (BaseModel model : models) {
            AssertionUtils.notNull((Object)model.getId(), (String)"identifier is not provided, can't update");
            updateClause.where(this.getPredicate((IdFilter)new IdFilter().setEquals(model.getId()), user));
            this.onUpdateInternal(updateClause, model, user);
            updateClause.addBatch();
        }
        long affectedRowsCount = updateClause.execute();
        if ((long)models.size() != affectedRowsCount) {
            this.log.debug("expect update '{}' row, but '{}' row(s) updated.", (Object)models.size(), (Object)affectedRowsCount);
        }
        return new ArrayList<M>(models);
    }

    protected void update(I identifier, Consumer<SQLUpdateClause> onUpdate, U user) {
        AssertionUtils.notNull(identifier, (String)"Given identifier cannot be null.");
        AssertionUtils.notNull(onUpdate, (String)"onUpdate cannot be null.");
        BaseCriteria criteria = (BaseCriteria)ReflectionUtils.newInstance((Class)this.criteriaClazz);
        criteria.setIdFilter((IdFilter)new IdFilter().setEquals(identifier));
        long affectedRowsCount = this.update((C)criteria, onUpdate, user);
        if (1L != affectedRowsCount) {
            this.log.error("expect update '{}' row, but '1' row(s) updated.", (Object)affectedRowsCount);
            throw new IllegalStateException("affected rows in update not valid");
        }
    }

    protected long update(C criteria, Consumer<SQLUpdateClause> onUpdate, U user) {
        AssertionUtils.notNull(criteria, (String)"Given criteria cannot be null.");
        AssertionUtils.notNull(onUpdate, (String)"onUpdate cannot be null.");
        SQLUpdateClause updateClause = this.getQueryFactory().update(this.getEntity());
        updateClause.where(this.getPredicate(criteria, user));
        onUpdate.accept(updateClause);
        return updateClause.execute();
    }

    @Transactional
    public M patch(I id, Map<String, Object> patch, U user) {
        AssertionUtils.notNull(id, (String)"id cannot be null.");
        AssertionUtils.notEmpty(patch, (String)"patch cannot be empty.");
        SQLUpdateClause updateClause = this.getQueryFactory().update(this.getEntity());
        updateClause.where(this.getPredicate((IdFilter)new IdFilter().setEquals(id), user));
        for (Map.Entry<String, Object> entry : patch.entrySet()) {
            Path<?> path = this.getPath(entry.getKey());
            if (null == entry.getValue()) {
                updateClause.setNull(path);
                continue;
            }
            updateClause.set(path, entry.getValue());
        }
        long affectedRowsCount = updateClause.execute();
        if (1L != affectedRowsCount) {
            throw new IllegalStateException("expect affect one row, but " + affectedRowsCount + " row(s) updated.");
        }
        return this.get(id, user);
    }

    @Transactional
    public long delete(I id, U user) {
        AssertionUtils.notNull(id, (String)"id should not be null.");
        return this.delete((C)Collections.singletonList(id), user);
    }

    @Transactional
    public long delete(Collection<I> ids, U user) {
        AssertionUtils.notEmpty(ids, (String)"Given ids cannot be null.");
        BaseCriteria criteria = (BaseCriteria)ReflectionUtils.newInstance((Class)this.criteriaClazz);
        criteria.setIdFilter((IdFilter)new IdFilter().setIn(ids));
        return this.delete((C)criteria, user);
    }

    @Transactional
    public long delete(C criteria, U user) {
        AssertionUtils.notNull(criteria, (String)"Criteria object should not be null.");
        SQLDeleteClause deleteClause = this.getQueryFactory().delete(this.getEntity());
        deleteClause.where(this.getPredicate(criteria.getIdFilter(), user));
        deleteClause.where(this.getPredicate(criteria, user));
        return deleteClause.execute();
    }

    protected <T extends StoreClause<T>> void onSaveInternal(T clause, M model, U user) {
        this.onSave(clause, model, user);
        for (Class<?> clazz : this.getClass().getInterfaces()) {
            if (!SaveExtendedRepositoryQdslSql.class.isAssignableFrom(clazz)) continue;
            ((SaveExtendedRepositoryQdslSql)((Object)this)).onSave(clause, model, user);
        }
    }

    protected <T extends StoreClause<T>> void onUpdateInternal(T clause, M model, U user) {
        this.onUpdate(clause, model, user);
        for (Class<?> clazz : this.getClass().getInterfaces()) {
            if (!UpdateExtendedRepositoryQdslSql.class.isAssignableFrom(clazz)) continue;
            ((UpdateExtendedRepositoryQdslSql)((Object)this)).onUpdate(clause, model, user);
        }
    }
}

