/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.crud.impl.querydsl.utils;

import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.dsl.ComparableExpression;
import com.querydsl.core.types.dsl.NumberExpression;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.core.types.dsl.StringPath;
import java.io.Serializable;
import java.util.Collection;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.bardframework.form.model.filter.Filter;
import org.bardframework.form.model.filter.NumberRangeFilter;
import org.bardframework.form.model.filter.RangeFilter;
import org.bardframework.form.model.filter.StringFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class QueryDslUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QueryDslUtils.class);
    private static final String EMPTY_CRITERIA_ERROR_MESSAGE = "The filter is empty;\nFilter on which no restrictions has been applied can be very dangerous in scenarios such as data deletion and cause unwanted deletion of data;\nInstead of using an empty filter (a filter that all its restrictions such as 'equals', 'notEquals', etc are empty), use the null criteria.";

    public static <T> Expression<T> bean(String alias, Class<T> type, Expression<?> ... expressions) {
        return ExpressionUtils.as((Expression)Projections.bean(type, expressions).skipNulls(), (String)alias);
    }

    public static <T> QBean<T> bean(Class<T> type, Expression<?> ... expressions) {
        return Projections.bean(type, expressions);
    }

    public static Predicate getPredicate(StringFilter filter, StringPath path) {
        if (null == filter) {
            return null;
        }
        if (filter.isEmpty()) {
            log.error("The filter is empty;\nFilter on which no restrictions has been applied can be very dangerous in scenarios such as data deletion and cause unwanted deletion of data;\nInstead of using an empty filter (a filter that all its restrictions such as 'equals', 'notEquals', etc are empty), use the null criteria.. filter: " + String.valueOf(filter));
            throw new IllegalArgumentException(EMPTY_CRITERIA_ERROR_MESSAGE);
        }
        BooleanBuilder builder = new BooleanBuilder(QueryDslUtils.getPredicate(filter, path));
        builder.and(QueryDslUtils.getPredicate(filter, path));
        if (StringUtils.isNotBlank((CharSequence)filter.getContains())) {
            builder.and((Predicate)path.likeIgnoreCase("%" + filter.getContains() + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)filter.getDoesNotContain())) {
            builder.and((Predicate)path.notLike("%" + filter.getDoesNotContain() + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)filter.getStartWith())) {
            builder.and((Predicate)path.likeIgnoreCase(filter.getStartWith() + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)filter.getEndWith())) {
            builder.and((Predicate)path.notLike("%" + filter.getDoesNotContain()));
        }
        return builder;
    }

    public static <T extends Number, F extends NumberRangeFilter<T, F>> Predicate getPredicate(NumberRangeFilter<T, F> filter, NumberExpression<T> path) {
        if (null == filter) {
            return null;
        }
        if (filter.isEmpty()) {
            log.error("The filter is empty;\nFilter on which no restrictions has been applied can be very dangerous in scenarios such as data deletion and cause unwanted deletion of data;\nInstead of using an empty filter (a filter that all its restrictions such as 'equals', 'notEquals', etc are empty), use the null criteria.. filter: " + String.valueOf(filter));
            throw new IllegalArgumentException(EMPTY_CRITERIA_ERROR_MESSAGE);
        }
        BooleanBuilder builder = new BooleanBuilder(QueryDslUtils.getPredicate(filter, path));
        if (filter.getFrom() != null) {
            builder.and((Predicate)path.goe((Number)filter.getFrom()));
        }
        if (filter.getTo() != null) {
            builder.and((Predicate)path.loe((Number)filter.getTo()));
        }
        return builder;
    }

    public static <T extends Comparable<?> & Serializable> Predicate getPredicate(RangeFilter<T, ?> filter, ComparableExpression<T> path) {
        if (null == filter) {
            return null;
        }
        if (filter.isEmpty()) {
            log.error("The filter is empty;\nFilter on which no restrictions has been applied can be very dangerous in scenarios such as data deletion and cause unwanted deletion of data;\nInstead of using an empty filter (a filter that all its restrictions such as 'equals', 'notEquals', etc are empty), use the null criteria.. filter: " + String.valueOf(filter));
            throw new IllegalArgumentException(EMPTY_CRITERIA_ERROR_MESSAGE);
        }
        BooleanBuilder builder = new BooleanBuilder(QueryDslUtils.getPredicate(filter, path));
        if (filter.getFrom() != null) {
            builder.and((Predicate)path.goe((Comparable)filter.getFrom()));
        }
        if (filter.getTo() != null) {
            builder.and((Predicate)path.loe((Comparable)filter.getTo()));
        }
        return builder;
    }

    public static <I> Predicate getPredicate(Filter<I, ?> filter, SimpleExpression<I> path) {
        return QueryDslUtils.getPredicate(filter, arg_0 -> path.eq(arg_0), arg_0 -> path.ne(arg_0), () -> path.isNotNull(), () -> path.isNull());
    }

    public static <I> Predicate getPredicate(Filter<I, ?> filter, Function<I, Predicate> equals, Function<I, Predicate> notEquals, Supplier<Predicate> isNotNull, Supplier<Predicate> isNull) {
        if (null == filter) {
            return null;
        }
        if (filter.isEmpty()) {
            log.error("The filter is empty;\nFilter on which no restrictions has been applied can be very dangerous in scenarios such as data deletion and cause unwanted deletion of data;\nInstead of using an empty filter (a filter that all its restrictions such as 'equals', 'notEquals', etc are empty), use the null criteria.. filter: " + String.valueOf(filter));
            throw new IllegalArgumentException(EMPTY_CRITERIA_ERROR_MESSAGE);
        }
        BooleanBuilder builder = new BooleanBuilder();
        if (null != filter.getEquals()) {
            builder.and(equals.apply(filter.getEquals()));
        }
        if (null != filter.getNotEquals()) {
            builder.and(notEquals.apply(filter.getNotEquals()));
        }
        if (CollectionUtils.isNotEmpty((Collection)filter.getIn())) {
            BooleanBuilder inBuilder = new BooleanBuilder();
            for (Object id : filter.getIn()) {
                inBuilder.or(equals.apply(id));
            }
            builder.and((Predicate)inBuilder);
        }
        if (CollectionUtils.isNotEmpty((Collection)filter.getNotIn())) {
            BooleanBuilder notInBuilder = new BooleanBuilder();
            for (Object id : filter.getNotIn()) {
                notInBuilder.and(notEquals.apply(id));
            }
            builder.and((Predicate)notInBuilder);
        }
        if (filter.getSpecified() != null) {
            if (filter.getSpecified().booleanValue()) {
                builder.and(isNotNull.get());
            } else {
                builder.and(isNull.get());
            }
        }
        return builder;
    }

    @Generated
    private QueryDslUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

