/*
 * Decompiled with CFR 0.152.
 */
package org.bboxdb.tools;

import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadLocalRandom;
import org.bboxdb.commons.math.Hyperrectangle;
import org.bboxdb.misc.BBoxDBException;
import org.bboxdb.network.client.BBoxDBCluster;
import org.bboxdb.network.client.future.client.EmptyResultFuture;
import org.bboxdb.network.client.future.client.TupleListFuture;
import org.bboxdb.storage.entity.DistributionGroupConfiguration;
import org.bboxdb.storage.entity.DistributionGroupConfigurationBuilder;
import org.bboxdb.storage.entity.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedSelftest {
    private static final String DISTRIBUTION_GROUP = "testgroup";
    private static final String TABLE = "testgroup_mytable";
    private static final int NUMBER_OF_OPERATIONS = 10000;
    private static final Logger logger = LoggerFactory.getLogger(DistributedSelftest.class);

    public static void main(String[] args) throws InterruptedException, ExecutionException, BBoxDBException {
        if (args.length < 2) {
            logger.error("Usage: DistributedSelftest <Cluster-Name> <Cluster-Endpoint1> <Cluster-EndpointN>");
            System.exit(-1);
        }
        logger.info("Running selftest......");
        String clustername = args[0];
        ArrayList<String> endpoints = new ArrayList<String>();
        for (int i = 1; i < args.length; ++i) {
            endpoints.add(args[i]);
        }
        BBoxDBCluster bboxdbCluster = new BBoxDBCluster(endpoints, clustername);
        bboxdbCluster.connect();
        if (!bboxdbCluster.isConnected()) {
            logger.error("Connection could not be established");
            System.exit(-1);
        }
        logger.info("Connected to cluster: " + clustername);
        logger.info("With endpoint(s): " + endpoints);
        DistributedSelftest.recreateDistributionGroup(bboxdbCluster);
        DistributedSelftest.executeSelftest(bboxdbCluster);
    }

    private static void recreateDistributionGroup(BBoxDBCluster bboxdbCluster) throws BBoxDBException, InterruptedException, ExecutionException {
        logger.info("Delete old distribution group: testgroup");
        EmptyResultFuture deleteFuture = bboxdbCluster.deleteDistributionGroup(DISTRIBUTION_GROUP);
        deleteFuture.waitForCompletion();
        if (deleteFuture.isFailed()) {
            logger.error("Unable to delete distribution group: testgroup");
            logger.error(deleteFuture.getAllMessages());
            System.exit(-1);
        }
        Thread.sleep(5000L);
        logger.info("Create new distribution group: testgroup");
        DistributionGroupConfiguration configuration = DistributionGroupConfigurationBuilder.create((int)2).withReplicationFactor((short)2).build();
        EmptyResultFuture createFuture = bboxdbCluster.createDistributionGroup(DISTRIBUTION_GROUP, configuration);
        createFuture.waitForCompletion();
        if (createFuture.isFailed()) {
            logger.error("Unable to create distribution group: testgroup");
            logger.error(createFuture.getAllMessages());
            System.exit(-1);
        }
        Thread.sleep(5000L);
    }

    private static void executeSelftest(BBoxDBCluster bboxdbClient) throws InterruptedException, ExecutionException, BBoxDBException {
        long iteration = 1L;
        while (true) {
            logger.info("Starting new iteration: " + iteration);
            DistributedSelftest.insertNewTuples(bboxdbClient);
            DistributedSelftest.queryForExistingTuplesByKey(bboxdbClient);
            DistributedSelftest.queryForExistingTuplesByTime(bboxdbClient);
            DistributedSelftest.deleteTuples(bboxdbClient);
            DistributedSelftest.queryForNonExistingTuples(bboxdbClient);
            Thread.sleep(1000L);
            ++iteration;
        }
    }

    private static void queryForExistingTuplesByTime(BBoxDBCluster bboxdbClient) throws InterruptedException, ExecutionException, BBoxDBException {
        int totalTuples;
        logger.info("Executing time query");
        TupleListFuture queryResult = bboxdbClient.queryVersionTime(TABLE, 0L);
        queryResult.waitForCompletion();
        if (queryResult.isFailed()) {
            logger.error("Time query result is failed");
            logger.error(queryResult.getAllMessages());
            System.exit(-1);
        }
        if ((totalTuples = Iterators.size((Iterator)queryResult.iterator())) != 10000) {
            logger.error("Got {} tuples back, but expected {}", (Object)totalTuples, (Object)10000);
            System.exit(-1);
        }
    }

    private static void deleteTuples(BBoxDBCluster bboxdbClient) throws InterruptedException, BBoxDBException, ExecutionException {
        logger.info("Deleting tuples");
        for (int i = 0; i < 10000; ++i) {
            String key = Integer.toString(i);
            EmptyResultFuture deletionResult = bboxdbClient.delete(TABLE, key);
            deletionResult.waitForCompletion();
            if (!deletionResult.isFailed()) continue;
            logger.error("Got an error while deleting: {} ", (Object)key);
            logger.error(deletionResult.getAllMessages());
            System.exit(-1);
        }
    }

    private static void queryForExistingTuplesByKey(BBoxDBCluster bboxdbClient) throws InterruptedException, ExecutionException, BBoxDBException {
        logger.info("Query for tuples");
        for (int i = 0; i < 10000; ++i) {
            int nextInt = ThreadLocalRandom.current().nextInt(10000);
            String key = Integer.toString(nextInt);
            TupleListFuture queryResult = bboxdbClient.queryKey(TABLE, key);
            queryResult.waitForCompletion();
            if (queryResult.isFailed()) {
                logger.error("Query {} : Got failed future, when query for: {}", (Object)i, (Object)key);
                logger.error(queryResult.getAllMessages());
                System.exit(-1);
            }
            boolean tupleFound = false;
            for (Tuple tuple : queryResult) {
                if (!tuple.getKey().equals(key)) {
                    logger.error("Query {}: Got tuple with wrong key.", (Object)i);
                    logger.error("Expected: {} but got: {}", (Object)i, (Object)tuple.getKey());
                    System.exit(-1);
                }
                tupleFound = true;
            }
            if (tupleFound) continue;
            logger.error("Query {}: Key {} not found", (Object)i, (Object)key);
            System.exit(-1);
        }
    }

    private static void queryForNonExistingTuples(BBoxDBCluster bboxdbClient) throws BBoxDBException, InterruptedException, ExecutionException {
        logger.info("Query for non existing tuples");
        for (int i = 0; i < 10000; ++i) {
            String key = Integer.toString(i);
            TupleListFuture queryResult = bboxdbClient.queryKey(TABLE, key);
            queryResult.waitForCompletion();
            if (queryResult.isFailed()) {
                logger.error("Query {}: Got failed future, when query for: {}", (Object)i, (Object)key);
                logger.error(queryResult.getAllMessages());
                System.exit(-1);
            }
            for (Tuple tuple : queryResult) {
                logger.error("Found a tuple which should not exist: {} / {}", (Object)i, (Object)tuple);
                System.exit(-1);
            }
        }
    }

    private static void insertNewTuples(BBoxDBCluster bboxdbClient) throws InterruptedException, ExecutionException, BBoxDBException {
        logger.info("Inserting new tuples");
        for (int i = 0; i < 10000; ++i) {
            String key = Integer.toString(i);
            Tuple myTuple = new Tuple(key, new Hyperrectangle(new Double[]{1.0, 2.0, 1.0, 2.0}), "test".getBytes());
            EmptyResultFuture insertResult = bboxdbClient.put(TABLE, myTuple);
            insertResult.waitForCompletion();
            if (!insertResult.isFailed()) continue;
            logger.error("Got an error during tuple insert: ", (Object)insertResult.getAllMessages());
            System.exit(-1);
        }
    }
}

