/*
 * Decompiled with CFR 0.152.
 */
package org.bboxdb.tools;

import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import org.apache.commons.compress.utils.CountingInputStream;
import org.bboxdb.commons.io.DataEncoderHelper;
import org.bboxdb.commons.io.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileLineIndex
implements AutoCloseable {
    protected final String filename;
    protected Path tmpDatabaseDir = null;
    private Database database = null;
    private Environment dbEnv = null;
    protected long indexedLines = 0L;
    private static final Logger logger = LoggerFactory.getLogger(FileLineIndex.class);

    public FileLineIndex(String filename) {
        this.filename = Objects.requireNonNull(filename);
    }

    public void indexFile() throws IOException {
        File file = new File(this.filename);
        if (!file.canRead()) {
            throw new IOException("Unable to open file: " + this.filename);
        }
        this.openDatabase();
        logger.info("Indexing file: {}", (Object)this.filename);
        this.indexedLines = 1L;
        this.registerLine(this.indexedLines, 0L);
        ++this.indexedLines;
        try (CountingInputStream inputStream = new CountingInputStream((InputStream)new BufferedInputStream(new FileInputStream(file)));){
            int bytesAvailabe = inputStream.available();
            while (bytesAvailabe > 0) {
                char readChar = (char)inputStream.read();
                if (readChar == '\n') {
                    this.registerLine(this.indexedLines, inputStream.getBytesRead());
                    ++this.indexedLines;
                }
                if (--bytesAvailabe != 0) continue;
                bytesAvailabe = inputStream.available();
            }
        }
        logger.info("Indexing file {} done. Indexed {} lines.", (Object)this.filename, (Object)this.getIndexedLines());
    }

    protected void openDatabase() throws IOException {
        EnvironmentConfig envConfig = new EnvironmentConfig();
        envConfig.setTransactional(false);
        envConfig.setAllowCreate(true);
        envConfig.setSharedCache(true);
        this.tmpDatabaseDir = Files.createTempDirectory(null, new FileAttribute[0]);
        this.dbEnv = new Environment(this.tmpDatabaseDir.toFile(), envConfig);
        logger.info("Database dir is {}", (Object)this.tmpDatabaseDir);
        FileUtil.deleteDirOnExit((Path)this.tmpDatabaseDir);
        DatabaseConfig dbConfig = new DatabaseConfig();
        dbConfig.setTransactional(false);
        dbConfig.setAllowCreate(true);
        dbConfig.setDeferredWrite(true);
        this.database = this.dbEnv.openDatabase(null, "lines", dbConfig);
    }

    @Override
    public void close() {
        if (this.database != null) {
            this.database.close();
            this.database = null;
        }
        if (this.dbEnv != null) {
            this.dbEnv.close();
            this.dbEnv = null;
        }
    }

    protected void registerLine(long line, long bytePos) {
        DatabaseEntry value;
        DatabaseEntry key = FileLineIndex.buildDatabaseEntry(line);
        OperationStatus status = this.database.put(null, key, value = FileLineIndex.buildDatabaseEntry(bytePos));
        if (status != OperationStatus.SUCCESS) {
            throw new RuntimeException("Data insertion, got status " + status);
        }
    }

    private static DatabaseEntry buildDatabaseEntry(long id) {
        ByteBuffer keyByteBuffer = DataEncoderHelper.longToByteBuffer((long)id);
        return new DatabaseEntry(keyByteBuffer.array());
    }

    public long locateLine(long line) {
        DatabaseEntry value;
        if (this.database == null) {
            throw new IllegalArgumentException("No database is open, please index file first");
        }
        if (line >= this.indexedLines) {
            throw new IllegalArgumentException("Line " + line + " is higher then indexedLines: " + (this.indexedLines - 1L));
        }
        DatabaseEntry key = FileLineIndex.buildDatabaseEntry(line);
        OperationStatus result = this.database.get(null, key, value = new DatabaseEntry(), LockMode.DEFAULT);
        if (result != OperationStatus.SUCCESS) {
            throw new RuntimeException("Data fetch got status " + result + " for " + line);
        }
        long bytePos = DataEncoderHelper.readLongFromByte((byte[])value.getData());
        return bytePos;
    }

    public long getIndexedLines() {
        return Math.max(0L, this.indexedLines - 1L);
    }
}

