/*
 * Decompiled with CFR 0.152.
 */
package org.bboxdb.tools;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.stream.Stream;
import org.bboxdb.commons.math.Hyperrectangle;
import org.bboxdb.commons.math.HyperrectangleHelper;
import org.bboxdb.storage.entity.Tuple;
import org.bboxdb.tools.converter.tuple.TupleBuilder;
import org.bboxdb.tools.converter.tuple.TupleBuilderFactory;

public class FilterJSONDataByBBox
implements Runnable {
    private final File file;
    private final Hyperrectangle boundingBox;
    private final TupleBuilder tupleBuilder;

    public FilterJSONDataByBBox(File file, String importFormat, Hyperrectangle boundingBox) {
        this.file = file;
        this.boundingBox = boundingBox;
        this.tupleBuilder = TupleBuilderFactory.getBuilderForFormat(importFormat);
    }

    @Override
    public void run() {
        try (Stream<String> stream = Files.lines(Paths.get(this.file.toURI()));){
            stream.forEach(l -> this.handleline((String)l));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void handleline(String line) {
        Tuple tuple = this.tupleBuilder.buildTuple(line);
        if (tuple == null) {
            System.err.println("Tuple is null: " + line);
            return;
        }
        if (this.boundingBox.intersects(tuple.getBoundingBox())) {
            System.out.println(line);
        }
    }

    public static void main(String[] args) {
        File file;
        if (args.length != 3) {
            System.err.println("Usage: <Class> <Filename> <InputFormat> <BBox>");
            System.exit(-1);
        }
        if (!(file = new File(args[0])).isFile()) {
            System.err.println("Unable to open: " + file);
            System.exit(-1);
        }
        String inputFormat = args[1];
        Optional boundingBox = HyperrectangleHelper.parseBBox((String)args[2]);
        if (!boundingBox.isPresent()) {
            System.err.println("Invalid bounding box: " + args[2]);
            System.exit(-1);
        }
        FilterJSONDataByBBox filter = new FilterJSONDataByBBox(file, inputFormat, (Hyperrectangle)boundingBox.get());
        filter.run();
    }
}

