/*
 * Decompiled with CFR 0.152.
 */
package org.bboxdb.tools;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.stream.Stream;
import org.bboxdb.commons.MathUtil;
import org.bboxdb.commons.math.GeoJsonPolygon;

public class FilterJSONDataByTime
implements Runnable {
    private final File file;
    private final long begin;
    private final long end;

    public FilterJSONDataByTime(File file, long begin, long end) {
        this.file = file;
        this.begin = begin;
        this.end = end;
    }

    @Override
    public void run() {
        try (Stream<String> stream = Files.lines(Paths.get(this.file.toURI()));){
            stream.forEach(l -> this.handleline((String)l));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void handleline(String line) {
        GeoJsonPolygon polygon = GeoJsonPolygon.fromGeoJson((String)line);
        String timestampstring = (String)polygon.getProperties().get("Timestamp");
        long timestamp = MathUtil.tryParseLongOrExit((String)timestampstring);
        if (timestamp > this.begin && timestamp < this.end) {
            System.out.println(line);
        }
    }

    public static void main(String[] args) {
        File file;
        if (args.length != 3) {
            System.err.println("Usage: <Class> <Filename> <Begin> <End>");
            System.exit(-1);
        }
        if (!(file = new File(args[0])).isFile()) {
            System.err.println("Unable to open: " + file);
            System.exit(-1);
        }
        long begin = MathUtil.tryParseLongOrExit((String)args[1]);
        long end = MathUtil.tryParseLongOrExit((String)args[2]);
        FilterJSONDataByTime filter = new FilterJSONDataByTime(file, begin, end);
        filter.run();
    }
}

