/*
 * Decompiled with CFR 0.152.
 */
package org.bboxdb.tools;

import java.util.List;
import java.util.concurrent.ExecutionException;
import org.bboxdb.commons.MicroSecondTimestampProvider;
import org.bboxdb.commons.RejectedException;
import org.bboxdb.commons.math.Hyperrectangle;
import org.bboxdb.misc.BBoxDBException;
import org.bboxdb.storage.StorageManagerException;
import org.bboxdb.storage.entity.Tuple;
import org.bboxdb.storage.entity.TupleStoreConfiguration;
import org.bboxdb.storage.entity.TupleStoreConfigurationBuilder;
import org.bboxdb.storage.entity.TupleStoreName;
import org.bboxdb.storage.tuplestore.manager.TupleStoreManager;
import org.bboxdb.storage.tuplestore.manager.TupleStoreManagerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalSelftest {
    protected static final String TABLENAME = "testgroup_testtable";
    protected static final int TUPLES = 1000000;
    private static final Logger logger = LoggerFactory.getLogger(LocalSelftest.class);

    public static void main(String[] args) throws InterruptedException, ExecutionException, BBoxDBException, StorageManagerException, RejectedException {
        if (args.length != 1) {
            logger.error("Usage: LocalSelftest <Iterations>");
            System.exit(-1);
        }
        try {
            int iterations = Integer.parseInt(args[0]);
            logger.info("Running selftest......");
            TupleStoreManagerRegistry storageRegistry = new TupleStoreManagerRegistry();
            storageRegistry.init();
            TupleStoreName tupleStoreName = new TupleStoreName(TABLENAME);
            TupleStoreConfiguration config = TupleStoreConfigurationBuilder.create().allowDuplicates(false).build();
            for (int iteration = 0; iteration < iterations; ++iteration) {
                TupleStoreManager storageManager = storageRegistry.createTable(tupleStoreName, config);
                logger.info("Running iteration {}", (Object)iteration);
                LocalSelftest.testInsertDelete(storageManager);
                storageRegistry.deleteTable(tupleStoreName);
            }
            storageRegistry.shutdown();
            logger.info("Selftest done");
        }
        catch (NumberFormatException e) {
            logger.error("Unable to parse {}\u00a0as a number, exiting", (Object)args[0]);
            System.exit(-1);
        }
    }

    private static void testInsertDelete(TupleStoreManager storageManager) throws StorageManagerException, InterruptedException, RejectedException {
        int i;
        logger.info("Inserting tuples...");
        for (i = 0; i < 1000000; ++i) {
            Tuple createdTuple = new Tuple(Integer.toString(i), Hyperrectangle.FULL_SPACE, Integer.toString(i).getBytes());
            storageManager.put(createdTuple);
        }
        Thread.sleep(1000L);
        logger.info("Key query...");
        for (i = 0; i < 1000000; ++i) {
            List resultTuples = storageManager.get(Integer.toString(i));
            assert (resultTuples.size() == 1);
            assert (((Tuple)resultTuples.get(0)).getKey().equals(Integer.toString(i)));
        }
        logger.info("Deleting tuples...");
        for (i = 0; i < 1000000; ++i) {
            storageManager.delete(Integer.toString(i), MicroSecondTimestampProvider.getNewTimestamp());
        }
        for (int iteration = 0; iteration < 4; ++iteration) {
            logger.info("Query deleted keys ({})...", (Object)iteration);
            for (int i2 = 0; i2 < 1000000; ++i2) {
                List resultTuples = storageManager.get(Integer.toString(i2));
                assert (resultTuples.isEmpty()) : "List is not empty";
            }
        }
        Thread.sleep(1000L);
    }
}

