/*
 * Decompiled with CFR 0.152.
 */
package org.bboxdb.tools;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.bboxdb.commons.math.Hyperrectangle;
import org.bboxdb.storage.entity.Tuple;
import org.bboxdb.tools.FileLineIndex;
import org.bboxdb.tools.converter.tuple.TupleBuilder;
import org.bboxdb.tools.converter.tuple.TupleBuilderFactory;

public class RandomSamplesReader {
    public static List<Hyperrectangle> readSamplesRandom(String filename, String format, double samplingPercent) throws IOException, FileNotFoundException {
        TupleBuilder tupleBuilder = TupleBuilderFactory.getBuilderForFormat(format);
        HashSet<Long> sampleLines = new HashSet<Long>();
        ArrayList<Hyperrectangle> samples = new ArrayList<Hyperrectangle>();
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(filename, "r");
             FileLineIndex fli = new FileLineIndex(filename);){
            System.out.format("Indexing %s%n", filename);
            fli.indexFile();
            long indexedLines = fli.getIndexedLines();
            long neededSamples = (long)(samplingPercent / 100.0 * (double)indexedLines);
            System.out.format("Indexing %s done (%d elements, taking %d samples) %n", filename, fli.getIndexedLines(), neededSamples);
            while ((long)sampleLines.size() < neededSamples) {
                long lineNumber = ThreadLocalRandom.current().nextLong(indexedLines);
                if (sampleLines.add(lineNumber)) continue;
            }
            ArrayList sampleLinesOrdered = new ArrayList(sampleLines);
            Collections.sort(sampleLinesOrdered);
            Iterator iterator = sampleLinesOrdered.iterator();
            while (iterator.hasNext()) {
                long lineNumber = (Long)iterator.next();
                Tuple tuple = null;
                int offset = 0;
                do {
                    String lineString = RandomSamplesReader.getLine(randomAccessFile, fli, lineNumber + (long)offset);
                    tuple = tupleBuilder.buildTuple(lineString, Long.toString(lineNumber + (long)offset));
                    ++offset;
                } while (tuple == null);
                samples.add(tuple.getBoundingBox());
            }
        }
        return samples;
    }

    private static String getLine(RandomAccessFile randomAccessFile, FileLineIndex fli, long lineNumber) throws IOException {
        long pos = fli.locateLine(lineNumber);
        randomAccessFile.seek(pos);
        String lineString = randomAccessFile.readLine();
        return lineString;
    }
}

