/*
 * Decompiled with CFR 0.152.
 */
package org.bboxdb.tools;

import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.List;
import org.bboxdb.storage.StorageManagerException;
import org.bboxdb.storage.entity.Tuple;
import org.bboxdb.storage.entity.TupleStoreName;
import org.bboxdb.storage.sstable.reader.SSTableFacade;
import org.bboxdb.storage.sstable.reader.SSTableKeyIndexReader;
import org.bboxdb.storage.sstable.reader.SSTableReader;
import org.bboxdb.storage.util.TupleHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSTableExaminer
implements Runnable {
    protected final String baseDirectory;
    protected final int tableNumber;
    protected final TupleStoreName relationname;
    protected final String examineKey;
    private static final String WILDCARD_KEY = "*";
    private static final Logger logger = LoggerFactory.getLogger(SSTableExaminer.class);

    public SSTableExaminer(String baseDirectory, TupleStoreName relationname, int tableNumber, String examineKey) {
        this.baseDirectory = baseDirectory;
        this.tableNumber = tableNumber;
        this.relationname = relationname;
        this.examineKey = examineKey;
    }

    @Override
    public void run() {
        try {
            SSTableFacade sstableFacade = new SSTableFacade(this.baseDirectory, this.relationname, this.tableNumber, 0);
            sstableFacade.init();
            if (!sstableFacade.acquire()) {
                throw new StorageManagerException("Unable to acquire sstable reader");
            }
            SSTableReader ssTableReader = sstableFacade.getSsTableReader();
            SSTableKeyIndexReader ssTableIndexReader = sstableFacade.getSsTableKeyIndexReader();
            this.fullTableScan(ssTableReader);
            if (!WILDCARD_KEY.equals(this.examineKey)) {
                this.internalScan(ssTableReader);
                this.seachViaIndex(ssTableReader, ssTableIndexReader);
            }
            sstableFacade.release();
            sstableFacade.shutdown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void seachViaIndex(SSTableReader ssTableReader, SSTableKeyIndexReader ssTableIndexReader) throws StorageManagerException {
        System.out.println("Step3: Seach via index");
        List positions = ssTableIndexReader.getPositionsForTuple(this.examineKey);
        System.out.println("Got index pos: " + positions);
        for (Integer position : positions) {
            System.out.println(ssTableReader.getTupleAtPosition(position.intValue()));
        }
    }

    protected void internalScan(SSTableReader ssTableReader) throws StorageManagerException {
        System.out.println("Step 2: Scan for tuple with key: " + this.examineKey);
        Tuple scanTuple = ssTableReader.scanForTuple(this.examineKey);
        System.out.println(scanTuple);
    }

    protected void fullTableScan(SSTableReader ssTableReader) throws IOException {
        System.out.println("Step 1: Looping over SSTable and searching for key: " + this.examineKey);
        int keys = 0;
        try {
            while (true) {
                Tuple tuple;
                if ((tuple = TupleHelper.decodeTuple((ByteBuffer)ssTableReader.getMemory())).getKey().equals(this.examineKey) || WILDCARD_KEY.equals(this.examineKey)) {
                    System.out.println(tuple);
                }
                ++keys;
            }
        }
        catch (BufferUnderflowException e) {
            System.out.println("Read " + keys + " tuples during scan");
            return;
        }
    }

    public static void main(String[] args) {
        if (args.length != 4) {
            logger.error("Usage: SSTableExaminer <Base directory> <Tablename> <Tablenumber> <Key>");
            logger.error("Use '*' as wildcard key");
            System.exit(-1);
        }
        String baseDirectory = args[0];
        TupleStoreName relationname = new TupleStoreName(args[1]);
        if (!relationname.isValid()) {
            logger.error("Relationname {}\u00a0is invalid, exiting", (Object)args[0]);
            System.exit(-1);
        }
        try {
            int tableNumber = Integer.parseInt(args[2]);
            String examineKey = args[3];
            SSTableExaminer dumper = new SSTableExaminer(baseDirectory, relationname, tableNumber, examineKey);
            dumper.run();
        }
        catch (NumberFormatException e) {
            logger.error("Unable to parse {} as tablenumber", (Object)args[2]);
            System.exit(-1);
        }
    }
}

