/*
 * Decompiled with CFR 0.152.
 */
package org.bboxdb.tools;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.bboxdb.commons.MathUtil;

public class SplitFile
implements Runnable {
    private final String filename;
    private final String outputDir;
    private final int linesPerBatch;
    private final int numberOfFiles;
    private final AtomicLong linesInBatch = new AtomicLong(0L);
    private final AtomicInteger currentBatch = new AtomicInteger(0);
    private final List<BufferedWriter> writers = new ArrayList<BufferedWriter>();

    public SplitFile(String filename, String outputDir, int linesPerBatch, int numberOfFiles) {
        this.filename = filename;
        this.outputDir = outputDir;
        this.linesPerBatch = linesPerBatch;
        this.numberOfFiles = numberOfFiles;
    }

    @Override
    public void run() {
        this.openFiles();
        try (Stream<String> stream = Files.lines(Paths.get(this.filename, new String[0]));){
            stream.forEach(l -> this.handleLine((String)l));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.closeFiles();
    }

    private void openFiles() {
        for (int fileNo = 0; fileNo < this.numberOfFiles; ++fileNo) {
            File file = new File(this.outputDir + File.separator + Integer.toString(fileNo));
            try {
                BufferedWriter writer = new BufferedWriter(new FileWriter(file));
                this.writers.add(writer);
                continue;
            }
            catch (IOException e) {
                System.err.println("Unable to open file for writing: " + file);
                e.printStackTrace();
                System.exit(-3);
            }
        }
    }

    private void closeFiles() {
        for (BufferedWriter writer : this.writers) {
            try {
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.writers.clear();
    }

    private void handleLine(String line) {
        try {
            this.linesInBatch.incrementAndGet();
            BufferedWriter writer = this.writers.get(this.currentBatch.get());
            writer.write(line);
            writer.write(System.lineSeparator());
        }
        catch (IOException e) {
            System.err.println("Unable to write line to file");
            e.printStackTrace();
            System.exit(-4);
        }
        if (this.linesInBatch.get() >= (long)this.linesPerBatch) {
            int curBatchValue = this.currentBatch.incrementAndGet();
            this.currentBatch.set(curBatchValue % this.numberOfFiles);
            this.linesInBatch.set(0L);
        }
    }

    public static void main(String[] args) {
        File outputdirFile;
        if (args.length != 4) {
            System.err.println("Usage: <Programm> <Filename> <OutputDir> <Lines per Batch> <Files>");
            System.exit(-1);
        }
        String filename = args[0];
        String outputDir = args[1];
        String linesPerBatchString = args[2];
        String numberOfFilesString = args[3];
        File file = new File(filename);
        if (!file.canRead()) {
            System.err.println("Unable to read file: " + file);
            System.exit(-1);
        }
        if ((outputdirFile = new File(outputDir)).exists()) {
            System.err.println("Output dir already exists, please remove: " + outputdirFile);
            System.exit(-2);
        }
        if (!outputdirFile.mkdirs()) {
            System.err.println("Unable to create: " + outputdirFile);
            System.exit(-2);
        }
        int linesPerBatch = MathUtil.tryParseIntOrExit((String)linesPerBatchString, () -> "Unable to parse as int: " + linesPerBatchString);
        int numberOfFiles = MathUtil.tryParseIntOrExit((String)numberOfFilesString, () -> "Unable to parse as int: " + numberOfFilesString);
        SplitFile splitFile = new SplitFile(filename, outputDir, linesPerBatch, numberOfFiles);
        splitFile.run();
    }
}

