/*
 * Decompiled with CFR 0.152.
 */
package org.bboxdb.tools;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.bboxdb.storage.entity.Tuple;
import org.bboxdb.tools.converter.tuple.TupleBuilder;
import org.bboxdb.tools.converter.tuple.TupleBuilderFactory;

public class TupleFileReader {
    private String filename;
    private final TupleBuilder tupleBuilder;
    private final double boxPadding;
    private final List<Consumer<? super Tuple>> callbacks;
    private long lineNumber;
    private long skippedLines;
    private String fileLine;
    private static final double DEFAULT_BOX_PADDING = 0.0;

    public TupleFileReader(String filename, String importFormat) {
        this(filename, importFormat, 0.0);
    }

    public TupleFileReader(String filename, String importFormat, double boxPadding) {
        this.filename = filename;
        this.boxPadding = boxPadding;
        this.tupleBuilder = TupleBuilderFactory.getBuilderForFormat(importFormat);
        this.callbacks = new ArrayList<Consumer<? super Tuple>>();
        this.tupleBuilder.setPadding(boxPadding);
    }

    public void addTupleListener(Consumer<? super Tuple> listener) {
        this.callbacks.add(listener);
    }

    public void processFile() throws IOException {
        this.processFile(Long.MAX_VALUE);
    }

    public void processFile(long maxLines) throws IOException {
        File file = new File(this.filename);
        if (!file.exists()) {
            throw new IOException("Unable to open file: " + file);
        }
        try (Stream<String> fileStream = Files.lines(Paths.get(this.filename, new String[0]));){
            this.lineNumber = 1L;
            this.skippedLines = 0L;
            Iterator iterator = fileStream.iterator();
            while (iterator.hasNext()) {
                this.fileLine = (String)iterator.next();
                Tuple tuple = this.tupleBuilder.buildTuple(this.fileLine, Long.toString(this.lineNumber));
                if (tuple == null) {
                    ++this.skippedLines;
                } else {
                    this.callbacks.forEach(c -> c.accept(tuple));
                }
                ++this.lineNumber;
                if (this.lineNumber <= maxLines) continue;
                break;
            }
        }
    }

    public long getProcessedLines() {
        return this.lineNumber;
    }

    public long getSkippedLines() {
        return this.skippedLines;
    }

    public String getLastReadLine() {
        return this.fileLine;
    }

    public double getBoxPadding() {
        return this.boxPadding;
    }
}

