/*
 * Decompiled with CFR 0.152.
 */
package org.bboxdb.tools.cli;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.bboxdb.commons.CloseableHelper;
import org.bboxdb.commons.MathUtil;
import org.bboxdb.commons.math.Hyperrectangle;
import org.bboxdb.commons.math.HyperrectangleHelper;
import org.bboxdb.distribution.DistributionGroupConfigurationCache;
import org.bboxdb.distribution.membership.BBoxDBInstanceManager;
import org.bboxdb.distribution.partitioner.AbstractTreeSpacePartitoner;
import org.bboxdb.distribution.partitioner.DistributionRegionState;
import org.bboxdb.distribution.partitioner.SpacePartitioner;
import org.bboxdb.distribution.partitioner.SpacePartitionerCache;
import org.bboxdb.distribution.region.DistributionRegion;
import org.bboxdb.distribution.zookeeper.DistributionGroupAdapter;
import org.bboxdb.distribution.zookeeper.DistributionRegionAdapter;
import org.bboxdb.distribution.zookeeper.ZookeeperClientFactory;
import org.bboxdb.distribution.zookeeper.ZookeeperException;
import org.bboxdb.distribution.zookeeper.ZookeeperNotFoundException;
import org.bboxdb.misc.BBoxDBException;
import org.bboxdb.misc.Const;
import org.bboxdb.network.client.BBoxDB;
import org.bboxdb.network.client.BBoxDBCluster;
import org.bboxdb.network.client.future.client.EmptyResultFuture;
import org.bboxdb.network.client.future.client.JoinedTupleListFuture;
import org.bboxdb.network.client.future.client.OperationFuture;
import org.bboxdb.network.client.future.client.TupleListFuture;
import org.bboxdb.network.client.tools.FixedSizeFutureStore;
import org.bboxdb.query.ContinuousQueryPlan;
import org.bboxdb.query.QueryPlanBuilder;
import org.bboxdb.query.filter.UserDefinedFilterDefinition;
import org.bboxdb.storage.entity.DistributionGroupConfiguration;
import org.bboxdb.storage.entity.DistributionGroupConfigurationBuilder;
import org.bboxdb.storage.entity.MultiTuple;
import org.bboxdb.storage.entity.Tuple;
import org.bboxdb.storage.entity.TupleStoreConfiguration;
import org.bboxdb.storage.entity.TupleStoreConfigurationBuilder;
import org.bboxdb.tools.RandomSamplesReader;
import org.bboxdb.tools.TupleFileReader;
import org.bboxdb.tools.cli.CLIAction;
import org.bboxdb.tools.cli.CLIHelper;
import org.bboxdb.tools.cli.OptionsHelper;
import org.bboxdb.tools.converter.tuple.TupleBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CLI
implements Runnable,
AutoCloseable {
    private CommandLine line;
    private BBoxDB bboxDbConnection;
    private final FixedSizeFutureStore pendingFutures;
    private static final int MAX_PENDING_FUTURES = 5000;
    private static final Logger logger = LoggerFactory.getLogger(CLI.class);

    public CLI(CommandLine line) {
        this.line = line;
        this.pendingFutures = new FixedSizeFutureStore(5000L, true);
        this.pendingFutures.addFailedFutureCallback(f -> {
            logger.error("Failed future detected: {}", (Object)f.getAllMessages());
            System.exit(-1);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        CLI cli = null;
        try {
            Options options = OptionsHelper.buildOptions();
            DefaultParser parser = new DefaultParser();
            CommandLine line = parser.parse(options, args);
            CLI.checkParameter(options, line);
            cli = new CLI(line);
            cli.run();
            CloseableHelper.closeWithoutException((AutoCloseable)cli);
        }
        catch (ParseException e) {
            System.err.println("Unable to parse commandline arguments: " + (Object)((Object)e));
            System.exit(-1);
        }
        finally {
            CloseableHelper.closeWithoutException(cli);
        }
        System.exit(0);
    }

    @Override
    public void run() {
        String action;
        String zookeeperHost = "localhost:2181";
        String zookeeperClustername = "mycluster";
        if (this.line.hasOption("zookeeperhost")) {
            zookeeperHost = this.line.getOptionValue("zookeeperhost");
        }
        if (this.line.hasOption("cluster")) {
            zookeeperClustername = this.line.getOptionValue("cluster");
        }
        System.out.print("Connecting to BBoxDB cluster...");
        System.out.flush();
        this.bboxDbConnection = new BBoxDBCluster(zookeeperHost, zookeeperClustername);
        if (!this.bboxDbConnection.connect()) {
            System.err.println("\n\n");
            System.err.println("Error: Unable to connect to the BBoxDB cluster.");
            System.err.format("Error: Did you specified the correct Zookeeper host (-%s=%s) and cluster (-%s=%s)?%n", "zookeeperhost", zookeeperHost, "cluster", zookeeperClustername);
            System.exit(-1);
        }
        System.out.println(" [Established]");
        if (this.line.hasOption("verbose")) {
            LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
            Configuration config = ctx.getConfiguration();
            LoggerConfig loggerConfig = config.getLoggerConfig("");
            loggerConfig.setLevel(Level.DEBUG);
            ctx.updateLoggers();
        }
        switch (action = this.line.getOptionValue("action")) {
            case "create_dgroup": {
                this.actionCreateDgroup(this.line);
                break;
            }
            case "delete_dgroup": {
                this.actionDeleteDgroup(this.line);
                break;
            }
            case "show_dgroup": {
                this.actionShowDgroup(this.line);
                break;
            }
            case "create_table": {
                this.actionCreateTable(this.line);
                break;
            }
            case "delete_table": {
                this.actionDeleteTable(this.line);
                break;
            }
            case "show_instances": {
                this.actionShowInstances(this.line);
                break;
            }
            case "import": {
                this.actionImportData(this.line);
                break;
            }
            case "query_key": {
                this.actionExecuteKeyQuery(this.line);
                break;
            }
            case "query_range": {
                this.actionExecuteRangeQuery(this.line);
                break;
            }
            case "query_range_and_time": {
                this.actionExecuteRangeAndTimeQuery(this.line);
                break;
            }
            case "query_time": {
                this.actionExecuteTimeQuery(this.line);
                break;
            }
            case "query_join": {
                this.actionExecuteJoin(this.line);
                break;
            }
            case "query_continuous": {
                this.actionExecuteContinuousQuery(this.line);
                break;
            }
            case "insert": {
                this.actionInsertTuple(this.line);
                break;
            }
            case "delete": {
                this.actionDeleteTuple(this.line);
                break;
            }
            case "prepartition": {
                this.prepartition(this.line);
                break;
            }
            default: {
                System.err.format("Unknown action %s%n", action);
            }
        }
    }

    @Override
    public void close() {
        if (this.bboxDbConnection != null) {
            this.bboxDbConnection.close();
            this.bboxDbConnection = null;
        }
    }

    private void actionCreateTable(CommandLine line) {
        if (!line.hasOption("table")) {
            System.err.println("Create table should be performed, but no table was specified");
            CLI.printHelpAndExit();
        }
        TupleStoreConfigurationBuilder ssTableConfigurationBuilder = TupleStoreConfigurationBuilder.create();
        if (line.hasOption("duplicates")) {
            String allowDuplicates = line.getOptionValue("duplicates");
            boolean duplicatesAllowed = MathUtil.tryParseBooleanOrExit((String)allowDuplicates, () -> "Unable to parse the bolean value for duplicates: " + allowDuplicates);
            ssTableConfigurationBuilder.allowDuplicates(duplicatesAllowed);
        }
        if (line.hasOption("ttl")) {
            String ttlString = line.getOptionValue("ttl");
            int ttl = MathUtil.tryParseIntOrExit((String)ttlString, () -> "Unable to parse the region size: " + ttlString);
            ssTableConfigurationBuilder.withTTL((long)ttl, TimeUnit.MILLISECONDS);
        }
        if (line.hasOption("versions")) {
            String versionString = line.getOptionValue("versions");
            int versions = MathUtil.tryParseIntOrExit((String)versionString, () -> "Unable to parse the version: " + versionString);
            ssTableConfigurationBuilder.withVersions(versions);
        }
        if (line.hasOption("sindexreader")) {
            String spatialIndexReader = line.getOptionValue("sindexreader");
            ssTableConfigurationBuilder.withSpatialIndexReader(spatialIndexReader);
        }
        if (line.hasOption("sindexwriter")) {
            String spatialIndexWriter = line.getOptionValue("sindexwriter");
            ssTableConfigurationBuilder.withSpatialIndexWriter(spatialIndexWriter);
        }
        TupleStoreConfiguration configuration = ssTableConfigurationBuilder.build();
        try {
            String table = line.getOptionValue("table");
            EmptyResultFuture resultFuture = this.bboxDbConnection.createTable(table, configuration);
            resultFuture.waitForCompletion();
            if (resultFuture.isFailed()) {
                System.err.println("Unable to create table: " + resultFuture.getAllMessages());
                System.exit(-1);
            }
        }
        catch (BBoxDBException e) {
            System.err.println("Got an exception while creating table: " + (Object)((Object)e));
            System.exit(-1);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
    }

    private void actionDeleteTable(CommandLine line) {
        if (!line.hasOption("table")) {
            System.err.println("Delete table should be performed, but no table was specified");
            CLI.printHelpAndExit();
        }
        try {
            String table = line.getOptionValue("table");
            EmptyResultFuture resultFuture = this.bboxDbConnection.deleteTable(table);
            resultFuture.waitForCompletion();
            if (resultFuture.isFailed()) {
                System.err.println("Unable to delete table: " + resultFuture.getAllMessages());
                System.exit(-1);
            }
        }
        catch (BBoxDBException e) {
            System.err.println("Got an exception while deleting table: " + (Object)((Object)e));
            System.exit(-1);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
    }

    private void actionExecuteKeyQuery(CommandLine line) {
        if (!line.hasOption("table")) {
            System.err.println("Query should be performed, but no table was specified");
            CLI.printHelpAndExit();
        }
        try {
            System.out.println("Executing key query..");
            String table = line.getOptionValue("table");
            String key = line.getOptionValue("key");
            TupleListFuture resultFuture = this.bboxDbConnection.queryKey(table, key);
            this.executeQueryFuture(resultFuture);
        }
        catch (BBoxDBException e) {
            System.err.println("Got an exception while performing query: " + (Object)((Object)e));
            System.exit(-1);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
    }

    private void actionExecuteRangeQuery(CommandLine line) {
        if (!line.hasOption("table")) {
            System.err.println("Query should be performed, but no table was specified");
            CLI.printHelpAndExit();
        }
        try {
            System.out.println("Executing the range query...");
            String table = line.getOptionValue("table");
            Hyperrectangle boundingBox = this.getBoundingBoxFromArgs(line);
            String customFilterClass = CLIHelper.getParameterOrDefault(line, "filter", "");
            String customFilterValue = CLIHelper.getParameterOrDefault(line, "filtervalue", "");
            ArrayList<UserDefinedFilterDefinition> udfs = new ArrayList<UserDefinedFilterDefinition>();
            if (customFilterClass.length() > 1) {
                UserDefinedFilterDefinition udf = new UserDefinedFilterDefinition(customFilterClass, customFilterValue);
                udfs.add(udf);
            }
            TupleListFuture resultFuture = this.bboxDbConnection.queryRectangle(table, boundingBox, udfs);
            this.executeQueryFuture(resultFuture);
        }
        catch (BBoxDBException e) {
            System.err.println("Got an exception while performing query: " + (Object)((Object)e));
            System.exit(-1);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
    }

    private void actionExecuteRangeAndTimeQuery(CommandLine line) {
        if (!line.hasOption("table")) {
            System.err.println("Query should be performed, but no table was specified");
            CLI.printHelpAndExit();
        }
        try {
            System.out.println("Executing the range and time query...");
            String table = line.getOptionValue("table");
            Hyperrectangle boundingBox = this.getBoundingBoxFromArgs(line);
            long timestamp = this.getTimestampFromArgs();
            TupleListFuture resultFuture = this.bboxDbConnection.queryRectangleAndTime(table, boundingBox, timestamp);
            this.executeQueryFuture(resultFuture);
        }
        catch (BBoxDBException e) {
            System.err.println("Got an exception while performing query: " + (Object)((Object)e));
            System.exit(-1);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
    }

    private void actionExecuteTimeQuery(CommandLine line) {
        if (!line.hasOption("table")) {
            System.err.println("Query should be performed, but no table was specified");
            CLI.printHelpAndExit();
        }
        try {
            System.out.println("Executing the time query...");
            String table = line.getOptionValue("table");
            long timestamp = this.getTimestampFromArgs();
            TupleListFuture resultFuture = this.bboxDbConnection.queryVersionTime(table, timestamp);
            this.executeQueryFuture(resultFuture);
        }
        catch (BBoxDBException e) {
            System.err.println("Got an exception while performing query: " + (Object)((Object)e));
            System.exit(-1);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
    }

    private void executeQueryFuture(TupleListFuture resultFuture) throws InterruptedException {
        if (resultFuture == null) {
            System.err.println("Unable to get query");
            System.exit(-1);
        }
        resultFuture.waitForCompletion();
        if (resultFuture.isFailed()) {
            System.err.println("Unable to execute query: " + resultFuture.getAllMessages());
            System.exit(-1);
        }
        long resultTuples = 0L;
        for (Tuple tuple : resultFuture) {
            this.printTuple(tuple);
            ++resultTuples;
        }
        this.printQueryDoneMessage(resultTuples);
    }

    private void printQueryDoneMessage(long resultTuples) {
        if (resultTuples == 1L) {
            System.out.format("Query done - got 1 result tuple%n", new Object[0]);
        } else {
            System.out.format("Query done - got %d result tuples%n", resultTuples);
        }
    }

    private void actionExecuteJoin(CommandLine line) {
        if (!line.hasOption("table")) {
            System.err.println("Query should be performed, but no table was specified");
            CLI.printHelpAndExit();
        }
        if (!line.hasOption("bbox")) {
            System.err.println("Bounding box is not given");
            System.exit(-1);
        }
        try {
            String tables = line.getOptionValue("table");
            List<String> tableList = Arrays.asList(tables.split(":"));
            Hyperrectangle boundingBox = this.getBoundingBoxFromArgs(line);
            JoinedTupleListFuture resultFuture1 = this.executeJoin(tableList, boundingBox);
            this.processJoinedTupleList(boundingBox, resultFuture1);
        }
        catch (BBoxDBException e) {
            System.err.println("Got an exception while performing query: " + (Object)((Object)e));
            System.exit(-1);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
    }

    private void processJoinedTupleList(Hyperrectangle boundingBox, JoinedTupleListFuture resultFuture1) {
        long resultTuples = 0L;
        for (MultiTuple tuple : resultFuture1) {
            assert (tuple.getBoundingBox().intersects(boundingBox)) : "Bounding box mismatch: " + tuple.getBoundingBox();
            Hyperrectangle box1 = tuple.getTuple(0).getBoundingBox();
            Hyperrectangle box2 = tuple.getTuple(1).getBoundingBox();
            assert (box1.intersects(boundingBox)) : "BBox 1 tuple mismatch: " + box1.toCompactString();
            assert (box2.intersects(boundingBox)) : "BBox 2 tuple mismatch: " + box2.toCompactString();
            assert (box2.intersects(box1)) : "Overlap mismatch: " + box1.toCompactString() + " " + box2.toCompactString();
            this.printJoinedTuple(tuple);
            ++resultTuples;
        }
        System.out.format("Join done - got %d tuples back%n", resultTuples);
    }

    private JoinedTupleListFuture executeJoin(List<String> tableList, Hyperrectangle boundingBox) throws BBoxDBException, InterruptedException {
        JoinedTupleListFuture resultFuture;
        System.out.println("Executing the spatial join query...");
        String customFilterClass = CLIHelper.getParameterOrDefault(this.line, "filter", "");
        String customFilterValue = CLIHelper.getParameterOrDefault(this.line, "filtervalue", "");
        ArrayList<UserDefinedFilterDefinition> udfs = new ArrayList<UserDefinedFilterDefinition>();
        if (customFilterClass.length() > 1) {
            UserDefinedFilterDefinition udf = new UserDefinedFilterDefinition(customFilterClass, customFilterValue);
            udfs.add(udf);
        }
        if ((resultFuture = this.bboxDbConnection.querySpatialJoin(tableList, boundingBox, udfs)) == null) {
            System.err.println("Unable to get query");
            System.exit(-1);
        }
        resultFuture.waitForCompletion();
        if (resultFuture.isFailed()) {
            System.err.println("Unable to execute query: " + resultFuture.getAllMessages());
            System.exit(-1);
        }
        return resultFuture;
    }

    private void actionExecuteContinuousQuery(CommandLine line) {
        if (!line.hasOption("table")) {
            System.err.println("Query should be performed, but no table was specified");
            CLI.printHelpAndExit();
        }
        try {
            System.out.println("Executing continuous range query...");
            String table = line.getOptionValue("table");
            if (!line.hasOption("bbox")) {
                System.err.println("Bounding box is not given");
                System.exit(-1);
            }
            Hyperrectangle boundingBox = this.getBoundingBoxFromArgs(line);
            ContinuousQueryPlan constQueryPlan = QueryPlanBuilder.createQueryOnTable((String)table).forAllNewTuplesInSpace(boundingBox).compareWithStaticSpace(boundingBox).build();
            JoinedTupleListFuture resultFuture = this.bboxDbConnection.queryContinuous(constQueryPlan);
            if (resultFuture == null) {
                System.err.println("Unable to get query");
                System.exit(-1);
            }
            resultFuture.waitForCompletion();
            if (resultFuture.isFailed()) {
                System.err.println("Unable to execute query: " + resultFuture.getAllMessages());
                System.exit(-1);
            }
            long resultTuples = 0L;
            for (MultiTuple tuple : resultFuture) {
                this.printJoinedTuple(tuple);
                ++resultTuples;
            }
            this.printQueryDoneMessage(resultTuples);
        }
        catch (BBoxDBException e) {
            System.err.println("Got an exception while performing query: " + (Object)((Object)e));
            System.exit(-1);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
    }

    private void printTuple(Tuple tuple) {
        System.out.println(tuple.getFormatedString());
    }

    private void printJoinedTuple(MultiTuple joinedTuple) {
        if (joinedTuple.getNumberOfTuples() == 1) {
            this.printTuple(joinedTuple.getTuple(0));
        } else {
            System.out.println(joinedTuple.getFormatedString());
        }
    }

    private long getTimestampFromArgs() {
        String timestampString = this.line.getOptionValue("time");
        long value = -1L;
        try {
            value = Long.parseLong(timestampString);
        }
        catch (NumberFormatException e) {
            System.err.println("Unable to parse timestamp: " + timestampString);
            CLI.printHelpAndExit();
        }
        return value;
    }

    private Hyperrectangle getBoundingBoxFromArgs(CommandLine line) {
        String bbox = line.getOptionValue("bbox");
        Optional resultBox = HyperrectangleHelper.parseBBox((String)bbox);
        if (!resultBox.isPresent()) {
            System.err.println("Invalid bounding box: " + bbox);
            System.exit(-1);
        }
        return (Hyperrectangle)resultBox.get();
    }

    private void actionDeleteTuple(CommandLine line) {
        if (!line.hasOption("key") || !line.hasOption("table")) {
            System.err.println("Key or table are missing");
            CLI.printHelpAndExit();
        }
        String key = line.getOptionValue("key");
        String table = line.getOptionValue("table");
        System.out.println("Deleting tuple for key: " + key);
        try {
            EmptyResultFuture resultFuture = this.bboxDbConnection.delete(table, key);
            this.pendingFutures.put((OperationFuture)resultFuture);
            this.pendingFutures.waitForCompletion();
        }
        catch (BBoxDBException e) {
            System.err.println("Got an error during delete: " + (Object)((Object)e));
            System.exit(-1);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
    }

    private void checkRequiredArgs(List<String> requiredArgs) {
        for (String arg : requiredArgs) {
            if (this.line.hasOption(arg)) continue;
            System.err.println("Option is missing: " + arg);
            CLI.printHelpAndExit();
        }
    }

    private void actionInsertTuple(CommandLine line) {
        List<String> requiredArgs = Arrays.asList("table", "key", "bbox", "value");
        this.checkRequiredArgs(requiredArgs);
        String table = line.getOptionValue("table");
        String key = line.getOptionValue("key");
        String value = line.getOptionValue("value");
        Hyperrectangle boundingBox = this.getBoundingBoxFromArgs(line);
        Tuple tuple = new Tuple(key, boundingBox, value.getBytes());
        System.out.println("Insert new tuple into table: " + table);
        try {
            EmptyResultFuture future = this.bboxDbConnection.put(table, tuple);
            this.pendingFutures.put((OperationFuture)future);
            this.pendingFutures.waitForCompletion();
        }
        catch (BBoxDBException e) {
            System.err.println("Got an error during insert: " + (Object)((Object)e));
            System.exit(-1);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
    }

    private void prepartition(CommandLine line) {
        List<String> requiredArgs = Arrays.asList("file", "format", "dgroup", "partitions");
        this.checkRequiredArgs(requiredArgs);
        String filename = line.getOptionValue("file");
        String format = line.getOptionValue("format");
        String distributionGroup = line.getOptionValue("dgroup");
        String parititonsString = line.getOptionValue("partitions");
        int partitions = MathUtil.tryParseIntOrExit((String)parititonsString, () -> "Unable to parse the partitions: " + parititonsString);
        try {
            CLI.exitIfGroupDoesNotExist(distributionGroup);
            CLI.checkForExistingPartitioning(distributionGroup);
            List<Hyperrectangle> allSamples = RandomSamplesReader.readSamplesRandom(filename, format, 0.1);
            System.out.println("Read samples: " + allSamples.size());
            SpacePartitioner partitioner = SpacePartitionerCache.getInstance().getSpacePartitionerForGroupName(distributionGroup);
            if (!(partitioner instanceof AbstractTreeSpacePartitoner)) {
                System.err.println("Unsupported space partitoner: " + partitioner);
                System.exit(-1);
            }
            AbstractTreeSpacePartitoner spacePartitioner = (AbstractTreeSpacePartitoner)partitioner;
            DistributionRegionAdapter adapter = ZookeeperClientFactory.getZookeeperClient().getDistributionRegionAdapter();
            HashMap<DistributionRegion, List<Hyperrectangle>> activeRegions = new HashMap<DistributionRegion, List<Hyperrectangle>>();
            List<DistributionRegion> readActiveRegions = this.getActiveRegions((SpacePartitioner)spacePartitioner);
            if (readActiveRegions.size() != 1) {
                System.err.println("Read more then one active region: " + readActiveRegions.size());
                System.exit(-1);
            }
            this.checkGroupAndSampleDimensions(allSamples, readActiveRegions);
            activeRegions.put(readActiveRegions.get(0), allSamples);
            while (activeRegions.keySet().size() < partitions) {
                DistributionRegion regionToSplit = (DistributionRegion)((Map.Entry)activeRegions.entrySet().stream().max((entry1, entry2) -> ((List)entry1.getValue()).size() > ((List)entry2.getValue()).size() ? 1 : -1).get()).getKey();
                System.out.format("Splitting region %d%n", regionToSplit.getRegionId());
                List newRegions = spacePartitioner.splitRegion(regionToSplit, (Collection)activeRegions.get(regionToSplit));
                spacePartitioner.waitForSplitChildsReadyZookeeperCallback(regionToSplit, 2);
                spacePartitioner.splitComplete(regionToSplit, newRegions);
                spacePartitioner.waitUntilNodeStateIs(regionToSplit, DistributionRegionState.SPLIT);
                for (DistributionRegion region : newRegions) {
                    adapter.setMergingSupported(region, false);
                }
                newRegions.forEach(d -> {
                    List cfr_ignored_0 = activeRegions.put((DistributionRegion)d, new ArrayList());
                });
                List oldSamples = (List)activeRegions.remove(regionToSplit);
                if (oldSamples.isEmpty()) {
                    System.err.println("Got empty samples for: " + regionToSplit.getIdentifier());
                }
                for (Hyperrectangle sample : oldSamples) {
                    boolean tupleDistributed = false;
                    for (DistributionRegion region : newRegions) {
                        if (!region.getConveringBox().intersects(sample)) continue;
                        ((List)activeRegions.get(region)).add(sample);
                        tupleDistributed = true;
                    }
                    if (tupleDistributed) continue;
                    System.err.println("Unable to distribute sample: " + sample);
                    System.exit(1);
                }
            }
            this.printSampleDistribution(activeRegions);
        }
        catch (Exception e) {
            logger.error("Got an exception", (Throwable)e);
            System.exit(-1);
        }
    }

    private void checkGroupAndSampleDimensions(List<Hyperrectangle> allSamples, List<DistributionRegion> readActiveRegions) {
        int groupDimensionality = readActiveRegions.get(0).getConveringBox().getDimension();
        int sampleDimensionality = allSamples.get(0).getDimension();
        if (sampleDimensionality != groupDimensionality) {
            System.err.println("Group dimensionality " + groupDimensionality + " and sample dimensionality " + sampleDimensionality + " differ");
            System.exit(-1);
        }
    }

    private void printSampleDistribution(Map<DistributionRegion, List<Hyperrectangle>> activeRegions) {
        System.out.println("=============================================");
        System.out.println("Distribution of samples after partitioning");
        System.out.println("=============================================");
        long maxValue = activeRegions.values().stream().mapToLong(l -> l.size()).max().getAsLong();
        double dots = 30.0;
        int maxRegionString = activeRegions.keySet().stream().map(s -> s.getIdentifier()).mapToInt(i -> i.length()).max().orElse(0);
        for (Map.Entry<DistributionRegion, List<Hyperrectangle>> entry : activeRegions.entrySet()) {
            int i2;
            DistributionRegion region = entry.getKey();
            List<Hyperrectangle> samples = entry.getValue();
            String identifier = region.getIdentifier();
            System.out.print("Region: '" + identifier + "' ");
            for (int i3 = 0; i3 < maxRegionString - identifier.length(); ++i3) {
                System.out.print(" ");
            }
            double dotsForRegionDouble = (double)samples.size() / (double)maxValue * 30.0;
            int dotsForRegion = (int)MathUtil.round((double)dotsForRegionDouble, (int)0);
            for (i2 = 0; i2 < dotsForRegion; ++i2) {
                System.out.print("*");
            }
            i2 = 0;
            while ((double)i2 < 30.0 - (double)dotsForRegion) {
                System.out.print(" ");
                ++i2;
            }
            System.out.println(" (samples: " + samples.size() + ")");
        }
        System.out.println("\n");
    }

    private static void exitIfGroupDoesNotExist(String distributionGroup) throws ZookeeperException, ZookeeperNotFoundException {
        DistributionGroupAdapter adapter = ZookeeperClientFactory.getZookeeperClient().getDistributionGroupAdapter();
        List knownGroups = adapter.getDistributionGroups();
        if (!knownGroups.contains(distributionGroup)) {
            System.err.format("Distribution group %s does not exist%n", distributionGroup);
            System.exit(-1);
        }
    }

    private static void checkForExistingPartitioning(String distributionGroup) throws BBoxDBException {
        SpacePartitioner spacePartitioner = SpacePartitionerCache.getInstance().getSpacePartitionerForGroupName(distributionGroup);
        if (spacePartitioner.getRootNode().getThisAndChildRegions().size() != 1) {
            System.err.println("Region is already splitted unable to use this for inital splitting");
            System.exit(-1);
        }
    }

    private List<DistributionRegion> getActiveRegions(SpacePartitioner spacePartitioner) throws BBoxDBException {
        return spacePartitioner.getRootNode().getThisAndChildRegions().stream().filter(r -> r.getState() == DistributionRegionState.ACTIVE).collect(Collectors.toList());
    }

    private void actionImportData(CommandLine line) {
        List<String> requiredArgs = Arrays.asList("file", "format", "table");
        this.checkRequiredArgs(requiredArgs);
        String filename = line.getOptionValue("file");
        String format = line.getOptionValue("format");
        String table = line.getOptionValue("table");
        String paddingString = CLIHelper.getParameterOrDefault(line, "bboxpadding", "0.0");
        double padding = MathUtil.tryParseDoubleOrExit((String)paddingString, () -> "Untable to parse: " + paddingString);
        System.out.format("Importing file: %s with padding %f%n", filename, padding);
        TupleFileReader tupleFile = new TupleFileReader(filename, format, padding);
        tupleFile.addTupleListener(t -> {
            if (tupleFile.getProcessedLines() % 1000L == 0L) {
                System.out.format("Read %d lines%n", tupleFile.getProcessedLines());
            }
            try {
                EmptyResultFuture result = this.bboxDbConnection.put(table, t);
                this.pendingFutures.put((OperationFuture)result);
            }
            catch (BBoxDBException e) {
                logger.error("Got exception while inserting tuple", (Throwable)e);
            }
        });
        try {
            tupleFile.processFile();
            this.pendingFutures.waitForCompletion();
            long skippedLines = tupleFile.getSkippedLines();
            long processedLines = tupleFile.getProcessedLines();
            System.out.format("Successfully imported %d lines (and skipped %d invalid lines) %n", processedLines - skippedLines, skippedLines);
        }
        catch (IOException e) {
            logger.error("Got IO Exception while reading data", (Throwable)e);
            System.exit(-1);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
    }

    private void actionDeleteDgroup(CommandLine line) {
        List<String> requiredArgs = Arrays.asList("dgroup");
        this.checkRequiredArgs(requiredArgs);
        String distributionGroup = line.getOptionValue("dgroup");
        System.out.println("Deleting distribution group: " + distributionGroup);
        try {
            EmptyResultFuture future = this.bboxDbConnection.deleteDistributionGroup(distributionGroup);
            future.waitForCompletion();
            if (future.isFailed()) {
                System.err.println("Got an error during distribution group deletion: " + future.getAllMessages());
                System.exit(-1);
            }
        }
        catch (BBoxDBException e) {
            System.err.println("Got an exception during distribution group creation: " + (Object)((Object)e));
            System.exit(-1);
        }
        catch (InterruptedException e) {
            System.err.println("Waiting was interrupted");
            System.exit(-1);
        }
    }

    private void actionShowInstances(CommandLine line) {
        System.out.println("Showing all discovered BBoxDB instances:");
        BBoxDBInstanceManager distributedInstanceManager = BBoxDBInstanceManager.getInstance();
        List allInstances = distributedInstanceManager.getInstances();
        allInstances.sort((i1, i2) -> i1.getIp().compareTo(i2.getIp()));
        System.out.println();
        System.out.println("#######");
        allInstances.forEach(i -> System.out.println(i));
        System.out.println("#######");
    }

    private void actionShowDgroup(CommandLine line) {
        List<String> requiredArgs = Arrays.asList("dgroup");
        this.checkRequiredArgs(requiredArgs);
        String distributionGroup = line.getOptionValue("dgroup");
        System.out.println("Show distribution group: " + distributionGroup);
        try {
            SpacePartitioner spacePartitioner = SpacePartitionerCache.getInstance().getSpacePartitionerForGroupName(distributionGroup);
            DistributionGroupConfiguration config = DistributionGroupConfigurationCache.getInstance().getDistributionGroupConfiguration(distributionGroup);
            short replicationFactor = config.getReplicationFactor();
            System.out.println("Replication factor is: " + replicationFactor);
            this.printDistributionRegionRecursive(spacePartitioner.getRootNode());
        }
        catch (ZookeeperNotFoundException | BBoxDBException e) {
            System.err.println("Got an exception during reading distribution group:" + e);
            System.exit(-1);
        }
    }

    private void printDistributionRegionRecursive(DistributionRegion distributionRegion) {
        if (distributionRegion == null) {
            return;
        }
        Hyperrectangle boundingBox = distributionRegion.getConveringBox();
        String bboxString = IntStream.range(0, boundingBox.getDimension()).mapToObj(i -> "Dimension:" + i + " " + boundingBox.getIntervalForDimension(i).toString()).collect(Collectors.joining(", "));
        String systemsString = distributionRegion.getSystems().stream().map(s -> s.getIp() + ":" + s.getPort()).collect(Collectors.joining(", ", "[", "]"));
        System.out.format("Region %d, Bounding Box=%s, State=%s, Systems=%s%n", distributionRegion.getRegionId(), bboxString, distributionRegion.getState(), systemsString);
        for (DistributionRegion region : distributionRegion.getDirectChildren()) {
            this.printDistributionRegionRecursive(region);
        }
    }

    private void actionCreateDgroup(CommandLine line) {
        List<String> requiredArgs = Arrays.asList("dgroup", "dimensions");
        this.checkRequiredArgs(requiredArgs);
        String maxRegionSizeString = CLIHelper.getParameterOrDefault(line, "maxregionsize", Integer.toString(256));
        String minRegionSizeString = CLIHelper.getParameterOrDefault(line, "minregionsize", Integer.toString(85));
        int maxRegionSize = MathUtil.tryParseIntOrExit((String)maxRegionSizeString, () -> "Unable to parse the max region size: " + maxRegionSizeString);
        int minRegionSize = MathUtil.tryParseIntOrExit((String)minRegionSizeString, () -> "Unable to parse the min region size: " + minRegionSizeString);
        String resourcePlacement = CLIHelper.getParameterOrDefault(line, "resourceplacement", Const.DEFAULT_PLACEMENT_STRATEGY);
        String resourcePlacementConfig = CLIHelper.getParameterOrDefault(line, "resourcepconfig", "");
        String spacePartitioner = CLIHelper.getParameterOrDefault(line, "spacepartitioner", Const.DEFAULT_SPACE_PARTITIONER);
        String spacePartitionerConfig = CLIHelper.getParameterOrDefault(line, "spacepconfig", "");
        String distributionGroup = line.getOptionValue("dgroup");
        String replicationFactorString = CLIHelper.getParameterOrDefault(line, "replicationfactor", "1");
        int replicationFactor = MathUtil.tryParseIntOrExit((String)replicationFactorString, () -> "This is not a valid replication factor: " + replicationFactorString);
        String dimensionsString = line.getOptionValue("dimensions");
        int dimensions = MathUtil.tryParseIntOrExit((String)dimensionsString, () -> "This is not a valid dimension: " + dimensionsString);
        System.out.println("Creating new distribution group: " + distributionGroup);
        try {
            DistributionGroupConfiguration configuration = DistributionGroupConfigurationBuilder.create((int)dimensions).withReplicationFactor((short)replicationFactor).withMaximumRegionSizeInMB(maxRegionSize).withMinimumRegionSizeInMB(minRegionSize).withPlacementStrategy(resourcePlacement, resourcePlacementConfig).withSpacePartitioner(spacePartitioner, spacePartitionerConfig).build();
            EmptyResultFuture future = this.bboxDbConnection.createDistributionGroup(distributionGroup, configuration);
            future.waitForCompletion();
            if (future.isFailed()) {
                System.err.println("Got an error during distribution group creation: " + future.getAllMessages());
                System.exit(-1);
            }
        }
        catch (BBoxDBException e) {
            System.err.println("Got an exception during distribution group creation: " + (Object)((Object)e));
            System.exit(-1);
        }
        catch (InterruptedException e) {
            System.err.println("Waiting was interrupted");
            System.exit(-1);
        }
    }

    private static void checkParameter(Options options, CommandLine line) {
        if (line.hasOption("help")) {
            CLI.printHelpAndExit();
        }
        if (!line.hasOption("action")) {
            CLI.printHelpAndExit();
        }
    }

    private static void printHelpAndExit() {
        Options options = OptionsHelper.buildOptions();
        String allActions = CLIAction.ALL_ACTIONS.stream().collect(Collectors.joining(", ", "[", "]"));
        String allBuilder = TupleBuilderFactory.ALL_BUILDER.stream().collect(Collectors.joining(", ", "[", "]"));
        String header = "BBoxDB command line interace (CLI)\n\nAvailable actions are: " + allActions + "\nSupported import formats: " + allBuilder + "\n\n";
        String footer = "\nPlease report issues at https://github.com/jnidzwetzki/bboxdb/issues\n";
        HelpFormatter formatter = new HelpFormatter();
        formatter.setWidth(120);
        formatter.printHelp("CLI", header, options, "\nPlease report issues at https://github.com/jnidzwetzki/bboxdb/issues\n");
        System.exit(-1);
    }
}

