/*
 * Decompiled with CFR 0.152.
 */
package org.bboxdb.tools.cli;

import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.bboxdb.misc.Const;

public class OptionsHelper {
    public static Options buildOptions() {
        Options options = new Options();
        Option help = Option.builder((String)"help").desc("Show this help").build();
        options.addOption(help);
        Option verbose = Option.builder((String)"verbose").desc("Be verbose").build();
        options.addOption(verbose);
        Option action = Option.builder((String)"action").hasArg().argName("action").desc("The CLI action to execute").build();
        options.addOption(action);
        Option host = Option.builder((String)"zookeeperhost").hasArg().argName("zookeeperhost").desc("The Zookeeper endpoint to connect to (default: 127.0.0.1:2181)").build();
        options.addOption(host);
        Option clusterName = Option.builder((String)"cluster").hasArg().argName("clustername").desc("The name of the cluster (default: mycluster)").build();
        options.addOption(clusterName);
        Option distributionGroup = Option.builder((String)"dgroup").hasArg().argName("distributiongroup").desc("The distribution group").build();
        options.addOption(distributionGroup);
        Option dimensions = Option.builder((String)"dimensions").hasArg().argName("dimensions").desc("The number of dimensions").build();
        options.addOption(dimensions);
        Option replicationFactor = Option.builder((String)"replicationfactor").hasArg().argName("replicationfactor").desc("The replication factor").build();
        options.addOption(replicationFactor);
        Option maxRegionSize = Option.builder((String)"maxregionsize").hasArg().argName("max region size (in MB)").desc("Default: 256").build();
        options.addOption(maxRegionSize);
        Option minRegionSize = Option.builder((String)"minregionsize").hasArg().argName("min region size (in MB)").desc("Default: 85").build();
        options.addOption(minRegionSize);
        Option resourcePlacement = Option.builder((String)"resourceplacement").hasArg().argName("ressource placement").desc("Default: " + Const.DEFAULT_PLACEMENT_STRATEGY).build();
        options.addOption(resourcePlacement);
        Option resourcePlacementConfig = Option.builder((String)"resourcepconfig").hasArg().argName("ressource placement config").desc("Default: ").build();
        options.addOption(resourcePlacementConfig);
        Option spacePartitioner = Option.builder((String)"spacepartitioner").hasArg().argName("space partitioner").desc("Default: " + Const.DEFAULT_SPACE_PARTITIONER).build();
        options.addOption(spacePartitioner);
        Option spacePartitionerConfig = Option.builder((String)"spacepconfig").hasArg().argName("space partitioner configuration").desc("Default: ").build();
        options.addOption(spacePartitionerConfig);
        Option duplplicatesInTable = Option.builder((String)"duplicates").hasArg().argName("duplicates").desc("Allow duplicates in the table, default: false").build();
        options.addOption(duplplicatesInTable);
        Option ttlForTable = Option.builder((String)"ttl").hasArg().argName("ttl").desc("The TTL of the tuple versions in milliseconds").build();
        options.addOption(ttlForTable);
        Option versionsForTable = Option.builder((String)"versions").hasArg().argName("versions").desc("The amount of versions for a tuple").build();
        options.addOption(versionsForTable);
        Option file = Option.builder((String)"file").hasArg().argName("file").desc("The file to read").build();
        options.addOption(file);
        Option format = Option.builder((String)"format").hasArg().argName("format").desc("The format of the file").build();
        options.addOption(format);
        Option table = Option.builder((String)"table").hasArg().argName("table").desc("The table to carry out the action").build();
        options.addOption(table);
        Option key = Option.builder((String)"key").hasArg().argName("key").desc("The name of the key").build();
        options.addOption(key);
        Option bbox = Option.builder((String)"bbox").hasArg().argName("bounding box").desc("The bounding box of the tuple").build();
        options.addOption(bbox);
        Option bboxPadding = Option.builder((String)"bboxpadding").hasArg().argName("bounding box padding").desc("The bounding box padding").build();
        options.addOption(bboxPadding);
        Option value = Option.builder((String)"value").hasArg().argName("value").desc("The value of the tuple").build();
        options.addOption(value);
        Option time = Option.builder((String)"time").hasArg().argName("timestamp").desc("The version time stamp of the tuple").build();
        options.addOption(time);
        Option filterclass = Option.builder((String)"filter").hasArg().argName("filterclass").desc("The classname of the custom filter").build();
        options.addOption(filterclass);
        Option filtervalue = Option.builder((String)"filtervalue").hasArg().argName("filtervalue").desc("The value for the custom filter").build();
        options.addOption(filtervalue);
        Option partitions = Option.builder((String)"partitions").hasArg().argName("partitions").desc("The number of partitions in the prepartitions").build();
        options.addOption(partitions);
        return options;
    }
}

