/*
 * Decompiled with CFR 0.152.
 */
package org.bboxdb.tools.converter.osm;

import org.bboxdb.commons.concurrent.ExceptionSafeRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSMConverterStatistics
extends ExceptionSafeRunnable {
    protected double processedNodes;
    protected double processedWays;
    protected long lastPerformaceTimestamp;
    protected double lastProcessedElements;
    protected long beginTimestamp;
    protected Thread thread;
    protected static final int DELAY_IN_MS = 1000;
    private static final Logger logger = LoggerFactory.getLogger(OSMConverterStatistics.class);

    public void start() {
        this.processedNodes = 0.0;
        this.lastPerformaceTimestamp = 0L;
        this.lastProcessedElements = 0.0;
        this.beginTimestamp = System.currentTimeMillis();
        this.thread = new Thread((Runnable)((Object)this));
        this.thread.start();
    }

    public void stop() {
        this.thread.interrupt();
        System.out.format("Imported %.0f nodes and %.0f ways%n", this.getProcessedNodes(), this.getProcessedWays());
    }

    protected void runThread() throws Exception {
        while (!Thread.interrupted()) {
            long now = System.currentTimeMillis();
            double totalProcessedElements = this.getTotalProcessedElements();
            double performanceTotal = totalProcessedElements / (double)((float)(now - this.beginTimestamp) / 1000.0f);
            double performanceSinceLastCall = (totalProcessedElements - this.lastProcessedElements) / (double)((float)(now - this.lastPerformaceTimestamp) / 1000.0f);
            String logMessage = String.format("Processing node %.0f and way %.0f / Elements per Sec %.2f / Total elements per Sec %.2f", this.processedNodes, this.processedWays, performanceSinceLastCall, performanceTotal);
            logger.info(logMessage);
            this.lastPerformaceTimestamp = now;
            this.lastProcessedElements = totalProcessedElements;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    public void incProcessedNodes() {
        this.processedNodes += 1.0;
    }

    public void incProcessedWays() {
        this.processedWays += 1.0;
    }

    public double getProcessedNodes() {
        return this.processedNodes;
    }

    public double getProcessedWays() {
        return this.processedWays;
    }

    public double getTotalProcessedElements() {
        return this.processedNodes + this.processedWays;
    }
}

