/*
 * Decompiled with CFR 0.152.
 */
package org.bboxdb.tools.converter.osm;

import crosby.binary.osmosis.OsmosisReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.bboxdb.commons.concurrent.ExceptionSafeRunnable;
import org.bboxdb.commons.math.GeoJsonPolygon;
import org.bboxdb.tools.converter.osm.OSMConverterStatistics;
import org.bboxdb.tools.converter.osm.OSMType;
import org.bboxdb.tools.converter.osm.filter.OSMTagEntityFilter;
import org.bboxdb.tools.converter.osm.filter.multipoint.OSMBuildingsEntityFilter;
import org.bboxdb.tools.converter.osm.filter.multipoint.OSMRoadsEntityFilter;
import org.bboxdb.tools.converter.osm.filter.multipoint.OSMWaterEntityFilter;
import org.bboxdb.tools.converter.osm.filter.multipoint.WoodEntityFilter;
import org.bboxdb.tools.converter.osm.filter.singlepoint.OSMTrafficSignalEntityFilter;
import org.bboxdb.tools.converter.osm.filter.singlepoint.OSMTreeEntityFilter;
import org.bboxdb.tools.converter.osm.store.OSMBDBNodeStore;
import org.bboxdb.tools.converter.osm.store.OSMJDBCDerbyNodeStore;
import org.bboxdb.tools.converter.osm.store.OSMJDBCH2NodeStore;
import org.bboxdb.tools.converter.osm.store.OSMNodeStore;
import org.bboxdb.tools.converter.osm.store.OSMSSTableNodeStore;
import org.bboxdb.tools.converter.osm.util.SerializableNode;
import org.bboxdb.tools.converter.osm.util.SerializerHelper;
import org.openstreetmap.osmosis.core.container.v0_6.EntityContainer;
import org.openstreetmap.osmosis.core.domain.v0_6.CommonEntityData;
import org.openstreetmap.osmosis.core.domain.v0_6.Node;
import org.openstreetmap.osmosis.core.domain.v0_6.OsmUser;
import org.openstreetmap.osmosis.core.domain.v0_6.Tag;
import org.openstreetmap.osmosis.core.domain.v0_6.Way;
import org.openstreetmap.osmosis.core.domain.v0_6.WayNode;
import org.openstreetmap.osmosis.core.task.v0_6.Sink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSMDataConverter {
    protected final String filename;
    protected final String output;
    protected final SerializerHelper<GeoJsonPolygon> serializerHelper = new SerializerHelper();
    protected final OSMConverterStatistics statistics;
    protected static final Map<OSMType, OSMTagEntityFilter> filter = new HashMap<OSMType, OSMTagEntityFilter>();
    protected final Map<OSMType, Writer> writerMap = new HashMap<OSMType, Writer>();
    protected final OSMNodeStore osmNodeStore;
    protected final ExecutorService threadPool;
    protected final int CONSUMER_THREADS = 5;
    protected final Way RED_PILL_WAY = new Way(new CommonEntityData(-1L, -1, new Date(), new OsmUser(1, ""), -1L));
    protected BlockingQueue<Way> queue = new LinkedBlockingQueue<Way>(1000);
    private static final Logger logger = LoggerFactory.getLogger(OSMDataConverter.class);

    public OSMDataConverter(String filename, String backend, String workfolder, String output) {
        this.filename = filename;
        this.output = output;
        this.statistics = new OSMConverterStatistics();
        File inputFile = new File(filename);
        List<String> workfolders = Arrays.asList(workfolder.split(":"));
        if ("bdb".equals(backend)) {
            this.osmNodeStore = new OSMBDBNodeStore(workfolders, inputFile.length());
        } else if ("jdbc_h2".equals(backend)) {
            this.osmNodeStore = new OSMJDBCH2NodeStore(workfolders, inputFile.length());
        } else if ("jdbc_DERBY".equals(backend)) {
            this.osmNodeStore = new OSMJDBCDerbyNodeStore(workfolders, inputFile.length());
        } else if ("sstable".equals(backend)) {
            this.osmNodeStore = new OSMSSTableNodeStore(workfolders, inputFile.length());
        } else {
            throw new RuntimeException("Unknown backend: " + backend);
        }
        this.threadPool = Executors.newCachedThreadPool();
        this.statistics.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        try {
            int i;
            for (OSMType osmType : filter.keySet()) {
                BufferedWriter bw = new BufferedWriter(new FileWriter(new File(this.output + File.separator + osmType.toString())));
                this.writerMap.put(osmType, bw);
            }
            System.out.format("Importing %s%n", this.filename);
            OsmosisReader reader = new OsmosisReader((InputStream)new FileInputStream(this.filename));
            reader.setSink(new Sink(){

                public void close() {
                }

                public void complete() {
                }

                public void initialize(Map<String, Object> metaData) {
                }

                public void process(EntityContainer entityContainer) {
                    try {
                        if (entityContainer.getEntity() instanceof Node) {
                            Node node = (Node)entityContainer.getEntity();
                            OSMDataConverter.this.handleNode(node);
                            OSMDataConverter.this.statistics.incProcessedNodes();
                        } else if (entityContainer.getEntity() instanceof Way) {
                            Way way = (Way)entityContainer.getEntity();
                            OSMDataConverter.this.queue.put(way);
                            OSMDataConverter.this.statistics.incProcessedWays();
                        }
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
            });
            for (i = 0; i < 5; ++i) {
                this.threadPool.submit((Runnable)((Object)new Consumer()));
            }
            reader.run();
            System.out.println("Processing of input file is complete");
            for (i = 0; i < 5; ++i) {
                this.queue.put(this.RED_PILL_WAY);
            }
        }
        catch (IOException e) {
            logger.error("Got an exception during import", (Throwable)e);
        }
        catch (InterruptedException e) {
            logger.error("Got interrupted exception", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        finally {
            this.shutdown();
        }
    }

    protected void shutdown() {
        this.threadPool.shutdown();
        try {
            this.threadPool.awaitTermination(120L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            logger.error("Unable to shutdown thread pool", (Throwable)e);
            Thread.currentThread().interrupt();
            return;
        }
        this.statistics.stop();
        for (Writer writer : this.writerMap.values()) {
            try {
                writer.close();
            }
            catch (IOException e) {
                logger.error("IO Exception while closing writer");
            }
        }
        this.writerMap.clear();
        this.osmNodeStore.close();
    }

    protected void handleNode(Node node) {
        try {
            for (Map.Entry<OSMType, OSMTagEntityFilter> osm : filter.entrySet()) {
                OSMType osmType = osm.getKey();
                OSMTagEntityFilter entityFilter = osm.getValue();
                if (!entityFilter.match(node.getTags())) continue;
                GeoJsonPolygon geometricalStructure = new GeoJsonPolygon(node.getId());
                geometricalStructure.addPoint(node.getLongitude(), node.getLatitude());
                for (Tag tag : node.getTags()) {
                    geometricalStructure.addProperty(tag.getKey(), tag.getValue());
                }
                this.writePolygonToOutput(osmType, geometricalStructure);
            }
            this.osmNodeStore.storeNode(node);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writePolygonToOutput(OSMType osmType, GeoJsonPolygon geometricalStructure) throws IOException {
        Writer writer;
        Writer writer2 = writer = this.writerMap.get((Object)osmType);
        synchronized (writer2) {
            writer.write(geometricalStructure.toGeoJson());
            writer.write("\n");
        }
    }

    protected void handleWay(Way way) {
        try {
            for (Map.Entry<OSMType, OSMTagEntityFilter> osm : filter.entrySet()) {
                OSMType osmType = osm.getKey();
                OSMTagEntityFilter entityFilter = osm.getValue();
                if (!entityFilter.match(way.getTags())) continue;
                GeoJsonPolygon geometricalStructure = new GeoJsonPolygon(way.getId());
                for (Tag tag : way.getTags()) {
                    geometricalStructure.addProperty(tag.getKey(), tag.getValue());
                }
                for (WayNode wayNode : way.getWayNodes()) {
                    SerializableNode node = this.osmNodeStore.getNodeForId(wayNode.getNodeId());
                    geometricalStructure.addPoint(node.getLongitude(), node.getLatitude());
                }
                this.writePolygonToOutput(osmType, geometricalStructure);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
        try {
            File outputDir;
            Options options = OSMDataConverter.buildOptions();
            DefaultParser parser = new DefaultParser();
            CommandLine line = parser.parse(options, args);
            OSMDataConverter.checkParameter(options, line);
            String filename = line.getOptionValue("input");
            String backend = line.getOptionValue("backend");
            String workfolder = line.getOptionValue("workfolder");
            String output = line.getOptionValue("output");
            File inputFile = new File(filename);
            if (!inputFile.isFile()) {
                System.err.println("Unable to open file: " + filename);
                System.exit(-1);
            }
            if ((outputDir = new File(output)).exists()) {
                System.err.println("Output dir already exist, please remove first");
                System.exit(-1);
            }
            if (!outputDir.mkdirs()) {
                System.err.println("Unable to create directory: " + output);
                System.exit(-1);
            }
            if (!Backend.ALL_BACKENDS.contains(backend)) {
                System.err.println("Backend with name is unkown: " + backend);
                OSMDataConverter.printHelpAndExit(options);
            }
            OSMDataConverter converter = new OSMDataConverter(filename, backend, workfolder, output);
            converter.start();
        }
        catch (ParseException e) {
            System.err.println("Unable to parse commandline arguments: " + (Object)((Object)e));
            System.exit(-1);
        }
    }

    private static void checkParameter(Options options, CommandLine line) {
        List<String> requiredArgs;
        boolean hasAllParameter;
        if (line.hasOption("help")) {
            OSMDataConverter.printHelpAndExit(options);
        }
        if (!(hasAllParameter = (requiredArgs = Arrays.asList("input", "output", "backend", "workfolder")).stream().allMatch(s -> line.hasOption(s)))) {
            OSMDataConverter.printHelpAndExit(options);
        }
    }

    private static Options buildOptions() {
        Options options = new Options();
        Option help = Option.builder((String)"help").desc("Show this help").build();
        options.addOption(help);
        Option input = Option.builder((String)"input").hasArg().argName("file").desc("The input file").build();
        options.addOption(input);
        Option output = Option.builder((String)"output").hasArg().argName("directory").desc("The output directory").build();
        options.addOption(output);
        String backendList = Backend.ALL_BACKENDS.stream().collect(Collectors.joining(",", "[", "]"));
        Option backend = Option.builder((String)"backend").hasArg().argName(backendList).desc("The node converter backend").build();
        options.addOption(backend);
        Option workfolder = Option.builder((String)"workfolder").hasArg().argName("workfolder1:workfolder2:workfolderN").desc("The working folder for the database").build();
        options.addOption(workfolder);
        return options;
    }

    private static void printHelpAndExit(Options options) {
        String header = "OpenStreetMap data converter\n\n";
        String footer = "\nPlease report issues at https://github.com/jnidzwetzki/bboxdb/issues\n";
        HelpFormatter formatter = new HelpFormatter();
        formatter.setWidth(200);
        formatter.printHelp("OSMConverter", "OpenStreetMap data converter\n\n", options, "\nPlease report issues at https://github.com/jnidzwetzki/bboxdb/issues\n");
        System.exit(-1);
    }

    static {
        filter.put(OSMType.TREE, new OSMTreeEntityFilter());
        filter.put(OSMType.WOOD, new WoodEntityFilter());
        filter.put(OSMType.TRAFFIC_SIGNAL, new OSMTrafficSignalEntityFilter());
        filter.put(OSMType.ROAD, new OSMRoadsEntityFilter());
        filter.put(OSMType.BUILDING, new OSMBuildingsEntityFilter());
        filter.put(OSMType.WATER, new OSMWaterEntityFilter());
    }

    class Consumer
    extends ExceptionSafeRunnable {
        Consumer() {
        }

        protected void runThread() {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    Way way = OSMDataConverter.this.queue.take();
                    if (OSMDataConverter.this.RED_PILL_WAY.equals((Object)way)) break;
                    OSMDataConverter.this.handleWay(way);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    logger.error("Got interrupted exception in comsumer, however queue size is still {}", (Object)OSMDataConverter.this.queue.size());
                }
            }
        }
    }

    static class Parameter {
        private static final String OUTPUT = "output";
        private static final String WORKFOLDER = "workfolder";
        private static final String BACKEND = "backend";
        private static final String INPUT = "input";
        private static final String HELP = "help";

        Parameter() {
        }
    }

    static class Backend {
        private static final String SSTABLE = "sstable";
        private static final String BDB = "bdb";
        private static final String JDBC_H2 = "jdbc_h2";
        private static final String JDBC_DERBY = "jdbc_DERBY";
        private static final List<String> ALL_BACKENDS = Arrays.asList("jdbc_h2", "jdbc_DERBY", "bdb", "sstable");

        Backend() {
        }
    }
}

