/*
 * Decompiled with CFR 0.152.
 */
package org.bboxdb.tools.converter.osm.store;

import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.Environment;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import java.util.List;
import org.bboxdb.commons.concurrent.ExceptionSafeRunnable;
import org.bboxdb.tools.converter.osm.store.OSMBDBNodeStore;
import org.bboxdb.tools.converter.osm.util.SerializableNode;

public class BDBWriterRunnable
extends ExceptionSafeRunnable {
    protected final List<SerializableNode> pendingWriteQueue;
    protected final Environment environment;
    protected final Database database;

    public BDBWriterRunnable(List<SerializableNode> pendingWriteQueue, Environment environment, Database database) {
        this.pendingWriteQueue = pendingWriteQueue;
        this.environment = environment;
        this.database = database;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runThread() {
        while (!Thread.currentThread().isInterrupted()) {
            SerializableNode nodeToProcess = null;
            List<SerializableNode> list = this.pendingWriteQueue;
            synchronized (list) {
                while (this.pendingWriteQueue.isEmpty()) {
                    try {
                        this.pendingWriteQueue.wait();
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
                nodeToProcess = this.pendingWriteQueue.get(0);
            }
            this.storeNode(nodeToProcess);
            list = this.pendingWriteQueue;
            synchronized (list) {
                this.pendingWriteQueue.remove(0);
                this.pendingWriteQueue.notifyAll();
            }
        }
    }

    protected void storeNode(SerializableNode node) {
        DatabaseEntry value;
        byte[] nodeBytes = node.toByteArray();
        Transaction txn = null;
        DatabaseEntry key = OSMBDBNodeStore.buildDatabaseKeyEntry(node.getId());
        OperationStatus status = this.database.put(txn, key, value = new DatabaseEntry(nodeBytes));
        if (status != OperationStatus.SUCCESS) {
            throw new RuntimeException("Data insertion got status " + status);
        }
        if (txn != null) {
            txn.commit();
        }
    }
}

