/*
 * Decompiled with CFR 0.152.
 */
package org.bboxdb.tools.converter.osm.store;

import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import java.io.File;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.bboxdb.commons.io.DataEncoderHelper;
import org.bboxdb.tools.converter.osm.store.BDBWriterRunnable;
import org.bboxdb.tools.converter.osm.store.OSMNodeStore;
import org.bboxdb.tools.converter.osm.util.SerializableNode;
import org.openstreetmap.osmosis.core.domain.v0_6.Node;

public class OSMBDBNodeStore
implements OSMNodeStore {
    protected final List<Environment> environments = new ArrayList<Environment>();
    protected final List<Database> databases = new ArrayList<Database>();
    protected List<List<SerializableNode>> pendingWriteQueues = new LinkedList<List<SerializableNode>>();
    protected static final int MAX_ELEMENTS_PER_QUEUE = 200;
    public static final boolean USE_TRANSACTIONS = false;
    protected int instances;
    protected ExecutorService threadPool = Executors.newCachedThreadPool();

    public OSMBDBNodeStore(List<String> baseDir, long inputLength) {
        this.instances = baseDir.size() == 1 ? 4 : baseDir.size();
        for (int i = 0; i < this.instances; ++i) {
            String workfolder = baseDir.get(i % baseDir.size());
            String folderName = workfolder + "/osm_" + i;
            File folder = new File(folderName);
            if (folder.exists()) {
                System.err.println("Folder already exists, exiting: " + folderName);
                System.exit(-1);
            }
            folder.mkdirs();
            this.pendingWriteQueues.add(new LinkedList());
            EnvironmentConfig envConfig = new EnvironmentConfig();
            envConfig.setTransactional(false);
            envConfig.setAllowCreate(true);
            envConfig.setSharedCache(true);
            this.initNewBDBEnvironment(folder, envConfig);
            BDBWriterRunnable bdbWriter = new BDBWriterRunnable(this.pendingWriteQueues.get(i), this.environments.get(i), this.databases.get(i));
            this.threadPool.submit((Runnable)((Object)bdbWriter));
        }
    }

    protected void initNewBDBEnvironment(File folder, EnvironmentConfig envConfig) {
        Environment dbEnv = new Environment(folder, envConfig);
        Transaction txn = null;
        DatabaseConfig dbConfig = new DatabaseConfig();
        dbConfig.setTransactional(false);
        dbConfig.setAllowCreate(true);
        dbConfig.setSortedDuplicates(true);
        dbConfig.setDeferredWrite(true);
        Database database = dbEnv.openDatabase(txn, "osm", dbConfig);
        if (txn != null) {
            txn.commit();
        }
        this.environments.add(dbEnv);
        this.databases.add(database);
    }

    @Override
    public void close() {
        this.databases.stream().forEach(p -> p.close());
        this.databases.clear();
        this.environments.stream().forEach(p -> p.close());
        this.environments.clear();
        this.threadPool.shutdownNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeNode(Node node) throws Exception {
        List<SerializableNode> queue;
        int connectionNumber = this.getConnectionPositionForNode(node.getId());
        List<SerializableNode> list = queue = this.pendingWriteQueues.get(connectionNumber);
        synchronized (list) {
            while (queue.size() > 200) {
                queue.wait();
            }
            SerializableNode serializableNode = new SerializableNode(node);
            queue.add(serializableNode);
            queue.notifyAll();
        }
    }

    public static DatabaseEntry buildDatabaseKeyEntry(long nodeId) {
        ByteBuffer keyByteBuffer = DataEncoderHelper.longToByteBuffer((long)nodeId);
        return new DatabaseEntry(keyByteBuffer.array());
    }

    protected int getConnectionPositionForNode(long nodeid) {
        return (int)(nodeid % (long)this.instances);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SerializableNode getNodeForId(long nodeId) throws SQLException {
        List<SerializableNode> queue;
        int connectionNumber = this.getConnectionPositionForNode(nodeId);
        Database database = this.databases.get(connectionNumber);
        List<SerializableNode> list = queue = this.pendingWriteQueues.get(connectionNumber);
        synchronized (list) {
            SerializableNode node = queue.stream().filter(n -> n.getId() == nodeId).findFirst().orElse(null);
            if (node != null) {
                return node;
            }
        }
        DatabaseEntry key = OSMBDBNodeStore.buildDatabaseKeyEntry(nodeId);
        DatabaseEntry value = new DatabaseEntry();
        OperationStatus result = database.get(null, key, value, LockMode.DEFAULT);
        if (result != OperationStatus.SUCCESS) {
            throw new RuntimeException("Data insertion got status " + result);
        }
        return SerializableNode.fromByteArray(value.getData());
    }

    @Override
    public int getInstances() {
        return this.instances;
    }
}

