/*
 * Decompiled with CFR 0.152.
 */
package org.bboxdb.tools.converter.osm.store;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.bboxdb.tools.converter.osm.store.OSMNodeStore;
import org.bboxdb.tools.converter.osm.util.SerializableNode;
import org.openstreetmap.osmosis.core.domain.v0_6.Node;

public class OSMJDBCDerbyNodeStore
implements OSMNodeStore {
    protected static final String DB_FLAGS = ";LOG=0;CACHE_SIZE=262144;LOCK_MODE=0;UNDO_LOG=0";
    protected final List<Connection> connections = new ArrayList<Connection>();
    protected final List<PreparedStatement> insertNodeStatements = new ArrayList<PreparedStatement>();
    protected final List<PreparedStatement> selectNodeStatements = new ArrayList<PreparedStatement>();
    protected int instances;

    public OSMJDBCDerbyNodeStore(List<String> baseDir, long inputLength) {
        this.instances = (int)((double)inputLength / Math.pow(1024.0, 3.0) * 5.0);
        System.out.println("Using DB instances: " + this.instances);
        try {
            for (int i = 0; i < this.instances; ++i) {
                String workfolder = baseDir.get(i % baseDir.size());
                Connection connection = DriverManager.getConnection("jdbc:h2:nio:" + workfolder + "/osm_" + i + ".db" + DB_FLAGS);
                try (Statement statement = connection.createStatement();){
                    statement.executeUpdate("DROP TABLE if exists osmnode");
                    statement.executeUpdate("CREATE TABLE osmnode (id BIGINT PRIMARY KEY, data BLOB)");
                }
                PreparedStatement insertNode = connection.prepareStatement("INSERT into osmnode (id, data) values (?,?)");
                PreparedStatement selectNode = connection.prepareStatement("SELECT data from osmnode where id = ?");
                this.insertNodeStatements.add(insertNode);
                this.selectNodeStatements.add(selectNode);
                connection.commit();
                this.connections.add(connection);
            }
        }
        catch (SQLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public void close() {
        this.selectNodeStatements.stream().forEach(p -> {
            try {
                p.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        });
        this.selectNodeStatements.clear();
        this.insertNodeStatements.stream().forEach(p -> {
            try {
                p.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        });
        this.insertNodeStatements.clear();
        this.connections.stream().forEach(p -> {
            try {
                p.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        });
        this.connections.clear();
    }

    @Override
    public void storeNode(Node node) throws SQLException, IOException {
        int connectionNumber = this.getDatabaseForNode(node.getId());
        Connection connection = this.connections.get(connectionNumber);
        PreparedStatement insertNode = this.insertNodeStatements.get(connectionNumber);
        SerializableNode serializableNode = new SerializableNode(node);
        byte[] nodeBytes = serializableNode.toByteArray();
        ByteArrayInputStream is = new ByteArrayInputStream(nodeBytes);
        insertNode.setLong(1, node.getId());
        insertNode.setBlob(2, is);
        insertNode.execute();
        ((InputStream)is).close();
        connection.commit();
    }

    protected int getDatabaseForNode(long nodeid) {
        return (int)(nodeid % (long)this.instances);
    }

    @Override
    public SerializableNode getNodeForId(long nodeId) throws SQLException {
        int connectionNumber = this.getDatabaseForNode(nodeId);
        PreparedStatement selectNode = this.selectNodeStatements.get(connectionNumber);
        selectNode.setLong(1, nodeId);
        ResultSet result = selectNode.executeQuery();
        if (!result.next()) {
            throw new RuntimeException("Unable to find node for way: " + nodeId);
        }
        byte[] nodeBytes = result.getBytes(1);
        result.close();
        SerializableNode node = SerializableNode.fromByteArray(nodeBytes);
        return node;
    }

    @Override
    public int getInstances() {
        return this.instances;
    }
}

