/*
 * Decompiled with CFR 0.152.
 */
package org.bboxdb.tools.converter.osm.store;

import java.util.List;
import org.bboxdb.commons.RejectedException;
import org.bboxdb.commons.math.Hyperrectangle;
import org.bboxdb.distribution.DistributionGroupConfigurationCache;
import org.bboxdb.misc.BBoxDBConfigurationManager;
import org.bboxdb.misc.BBoxDBException;
import org.bboxdb.storage.StorageManagerException;
import org.bboxdb.storage.entity.DistributionGroupConfiguration;
import org.bboxdb.storage.entity.Tuple;
import org.bboxdb.storage.entity.TupleStoreName;
import org.bboxdb.storage.tuplestore.manager.TupleStoreManager;
import org.bboxdb.storage.tuplestore.manager.TupleStoreManagerRegistry;
import org.bboxdb.tools.converter.osm.store.OSMNodeStore;
import org.bboxdb.tools.converter.osm.util.SerializableNode;
import org.openstreetmap.osmosis.core.domain.v0_6.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSMSSTableNodeStore
implements OSMNodeStore {
    protected int instances;
    protected TupleStoreManager storageManager;
    protected TupleStoreManagerRegistry storageRegistry;
    private static final Logger logger = LoggerFactory.getLogger(OSMSSTableNodeStore.class);

    public OSMSSTableNodeStore(List<String> storageDirectories, long inputLength) {
        TupleStoreName tableName = new TupleStoreName("group1_test");
        DistributionGroupConfiguration configuration = new DistributionGroupConfiguration(2);
        DistributionGroupConfigurationCache.getInstance().addNewConfiguration("group1", configuration);
        this.storageRegistry = new TupleStoreManagerRegistry();
        try {
            this.storageRegistry.init();
            BBoxDBConfigurationManager.getConfiguration().setStorageDirectories(storageDirectories);
            this.storageRegistry.deleteTable(tableName);
            this.storageManager = this.storageRegistry.getTupleStoreManager(tableName);
        }
        catch (InterruptedException | BBoxDBException | StorageManagerException e) {
            logger.error("Got an exception while getting sstable manager: ", e);
        }
    }

    @Override
    public void close() {
        if (this.storageRegistry != null) {
            this.storageRegistry.shutdown();
            this.storageRegistry = null;
        }
    }

    @Override
    public void storeNode(Node node) throws StorageManagerException, RejectedException {
        SerializableNode serializableNode = new SerializableNode(node);
        byte[] nodeBytes = serializableNode.toByteArray();
        Tuple tuple = new Tuple(Long.toString(node.getId()), Hyperrectangle.FULL_SPACE, nodeBytes);
        this.storageManager.put(tuple);
    }

    protected int getDatabaseForNode(long nodeid) {
        return (int)(nodeid % (long)this.instances);
    }

    @Override
    public SerializableNode getNodeForId(long nodeId) throws StorageManagerException {
        List tuples = this.storageManager.get(Long.toString(nodeId));
        if (tuples.isEmpty()) {
            throw new StorageManagerException("Unable to locate tuple for: " + nodeId);
        }
        byte[] nodeBytes = ((Tuple)tuples.get(0)).getDataBytes();
        return SerializableNode.fromByteArray(nodeBytes);
    }

    @Override
    public int getInstances() {
        return this.instances;
    }
}

