/*
 * Decompiled with CFR 0.152.
 */
package org.bboxdb.tools.converter.osm.util;

import java.nio.ByteBuffer;
import org.bboxdb.misc.Const;
import org.openstreetmap.osmosis.core.domain.v0_6.Node;

public class SerializableNode {
    protected final long id;
    protected final double latitude;
    protected final double longitude;
    protected final long timestamp;
    protected final int version;

    public SerializableNode(Node node) {
        this.latitude = node.getLatitude();
        this.longitude = node.getLongitude();
        this.id = node.getId();
        this.timestamp = node.getTimestamp().getTime();
        this.version = node.getVersion();
    }

    public SerializableNode(long id, double latitude, double longitude, long timestamp, int version) {
        this.id = id;
        this.latitude = latitude;
        this.longitude = longitude;
        this.timestamp = timestamp;
        this.version = version;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public long getId() {
        return this.id;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int getVersion() {
        return this.version;
    }

    public byte[] toByteArray() {
        int length = 36;
        ByteBuffer bb = ByteBuffer.allocate(36);
        bb.order(Const.APPLICATION_BYTE_ORDER);
        bb.putLong(this.id);
        bb.putDouble(this.latitude);
        bb.putDouble(this.longitude);
        bb.putLong(this.timestamp);
        bb.putInt(this.version);
        return bb.array();
    }

    public static SerializableNode fromByteArray(byte[] bytes) {
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        bb.order(Const.APPLICATION_BYTE_ORDER);
        long id = bb.getLong();
        double latitude = bb.getDouble();
        double longitude = bb.getDouble();
        long timestamp = bb.getLong();
        int version = bb.getInt();
        assert (!bb.hasRemaining()) : "Byte buffer is not empty";
        return new SerializableNode(id, latitude, longitude, timestamp, version);
    }
}

