/*
 * Decompiled with CFR 0.152.
 */
package org.bboxdb.tools.converter.tuple;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.bboxdb.commons.InputParseException;
import org.bboxdb.commons.MathUtil;
import org.bboxdb.commons.math.GeoJsonPolygon;
import org.bboxdb.commons.math.Hyperrectangle;
import org.bboxdb.misc.Const;
import org.bboxdb.storage.entity.Tuple;
import org.bboxdb.tools.converter.tuple.TupleBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ADSBTupleBuilder2D
extends TupleBuilder {
    private final Map<String, Aircraft> aircrafts = new HashMap<String, Aircraft>();
    private final SimpleDateFormat dateParser = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
    private static final Logger logger = LoggerFactory.getLogger(ADSBTupleBuilder2D.class);

    public ADSBTupleBuilder2D() {
        this.dateParser.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    @Override
    public Tuple buildTuple(String valueData, String keyData) {
        try {
            if (!valueData.startsWith("MSG,")) {
                return null;
            }
            String[] data = valueData.split(",");
            if (data.length < 5) {
                throw new IllegalArgumentException("Unable split: " + valueData + " / " + data.length);
            }
            String transmissionType = data[1];
            Aircraft aircraft = this.updateAircraft(data, transmissionType);
            if ("4".equals(transmissionType) && aircraft.isComplete()) {
                Hyperrectangle boundingBox = this.getHyperrectangleFromAircraft(aircraft);
                return new Tuple(aircraft.callsign, boundingBox.enlargeByAmount(this.boxPadding), aircraft.toGeoJSON().getBytes(Const.DEFAULT_CHARSET), aircraft.lastUpdateTimestamp * 1000L);
            }
            return null;
        }
        catch (Exception e) {
            logger.error("Unabe to parse: " + valueData, (Throwable)e);
            return null;
        }
    }

    protected Hyperrectangle getHyperrectangleFromAircraft(Aircraft aircraft) throws InputParseException {
        return new Hyperrectangle(new Double[]{aircraft.latitude, aircraft.latitude, aircraft.longitude, aircraft.longitude});
    }

    private Aircraft updateAircraft(String[] data, String transmissionType) throws InputParseException, ParseException {
        String hexIdent = data[4];
        if (hexIdent == null) {
            throw new IllegalArgumentException("Received message without hexIdent");
        }
        Aircraft aircraft = this.aircrafts.computeIfAbsent(hexIdent, k -> new Aircraft((String)k));
        String receivedDate = data[8];
        String receivedTime = data[9];
        String dateTime = receivedDate + " " + receivedTime;
        Date date = this.dateParser.parse(dateTime);
        aircraft.lastUpdateTimestamp = date.getTime();
        block9: for (int pos = 10; pos <= 16 && data.length >= pos + 1; ++pos) {
            String value = data[pos];
            if ("".equals(value)) continue;
            switch (pos) {
                case 10: {
                    aircraft.callsign = value;
                    continue block9;
                }
                case 11: {
                    aircraft.altitude = value;
                    continue block9;
                }
                case 12: {
                    aircraft.groundSpeed = value;
                    continue block9;
                }
                case 13: {
                    aircraft.track = value;
                    continue block9;
                }
                case 14: {
                    aircraft.latitude = MathUtil.tryParseDouble((String)value, () -> "Unable to parse latitude");
                    continue block9;
                }
                case 15: {
                    aircraft.longitude = MathUtil.tryParseDouble((String)value, () -> "Unable to parse longitude");
                    continue block9;
                }
                case 16: {
                    aircraft.verticalRate = value;
                    continue block9;
                }
                default: {
                    throw new IllegalArgumentException("Unable to handle element: " + value + " " + pos);
                }
            }
        }
        return aircraft;
    }

    static class Aircraft {
        public final String hexIdent;
        public String callsign = null;
        public String altitude = null;
        public String groundSpeed = null;
        public String track = null;
        public String verticalRate = null;
        public double latitude = -1.0;
        public double longitude = -1.0;
        public long lastUpdateTimestamp = -1L;

        public Aircraft(String hexIdent) {
            this.hexIdent = hexIdent;
        }

        public String toGeoJSON() {
            int id = Integer.parseInt(this.hexIdent, 16);
            GeoJsonPolygon geoJsonPolygon = new GeoJsonPolygon((long)id);
            geoJsonPolygon.addPoint(this.latitude, this.longitude);
            geoJsonPolygon.addProperty("Callsign", this.callsign);
            geoJsonPolygon.addProperty("Altitude", this.altitude);
            geoJsonPolygon.addProperty("GroundSpeed", this.groundSpeed);
            geoJsonPolygon.addProperty("Track", this.track);
            geoJsonPolygon.addProperty("VerticalRate", this.verticalRate);
            geoJsonPolygon.addProperty("LastUpdateTimestamp", Long.toString(this.lastUpdateTimestamp));
            return geoJsonPolygon.toGeoJson();
        }

        public boolean isComplete() {
            return this.callsign != null && this.altitude != null && this.groundSpeed != null && this.track != null && this.verticalRate != null && this.latitude != -1.0 && this.longitude != -1.0 && this.lastUpdateTimestamp != -1L;
        }

        public String toString() {
            return "Aircraft [hexIdent=" + this.hexIdent + ", callsign=" + this.callsign + ", altitude=" + this.altitude + ", groundSpeed=" + this.groundSpeed + ", track=" + this.track + ", verticalRate=" + this.verticalRate + ", latitude=" + this.latitude + ", longitude=" + this.longitude + ", lastUpdateTimestamp=" + this.lastUpdateTimestamp + "]";
        }
    }
}

