/*
 * Decompiled with CFR 0.152.
 */
package org.bboxdb.tools.converter.tuple;

import java.util.Map;
import org.bboxdb.commons.math.GeoJsonPolygon;
import org.bboxdb.commons.math.Hyperrectangle;
import org.bboxdb.misc.Const;
import org.bboxdb.storage.entity.Tuple;
import org.bboxdb.tools.converter.tuple.TupleBuilder;

public class AuTransportGeoJSONTupleBuilder
extends TupleBuilder {
    @Override
    public Tuple buildTuple(String valueData, String keyData) {
        GeoJsonPolygon polygon = GeoJsonPolygon.fromGeoJson((String)valueData);
        Map properties = polygon.getProperties();
        String key = keyData;
        key = properties.containsKey("TripID") ? ((String)properties.get("TripID")).replace(" ", "_") : ((String)properties.get("RouteID")).replace(" ", "_");
        polygon.invertPolygonCoordinates();
        byte[] tupleBytes = polygon.toGeoJson().getBytes(Const.DEFAULT_CHARSET);
        if (polygon.getBoundingBox().getDimension() == 0) {
            return null;
        }
        Hyperrectangle bbox = polygon.getBoundingBox().enlargeByAmount(this.boxPadding);
        if (properties.containsKey("Timestamp")) {
            return new Tuple(key, bbox, tupleBytes, Long.parseLong((String)properties.get("Timestamp")) * 1000L * 1000L);
        }
        return new Tuple(key, bbox, tupleBytes);
    }
}

