/*
 * Decompiled with CFR 0.152.
 */
package org.bboxdb.tools.converter.tuple;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.bboxdb.commons.MathUtil;
import org.bboxdb.commons.math.GeoJsonPolygon;
import org.bboxdb.commons.math.Hyperrectangle;
import org.bboxdb.misc.Const;
import org.bboxdb.storage.entity.Tuple;
import org.bboxdb.tools.converter.tuple.TupleBuilder;

public class BerlinModPlayerTupleBuilder
extends TupleBuilder {
    private final SimpleDateFormat dateParser = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");

    public BerlinModPlayerTupleBuilder() {
        this.dateParser.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    @Override
    public Tuple buildTuple(String valueData, String keyData) {
        if ("Moid,Tripid,Tstart,Tend,Xstart,Ystart,Xend,Yend".equals(valueData)) {
            return null;
        }
        String[] values = valueData.split(",");
        if (values.length != 5) {
            throw new RuntimeException("Unable to decode tuple: " + valueData);
        }
        String key = keyData != null ? keyData : values[1];
        long polygonId = MathUtil.tryParseLongOrExit((String)key, () -> "Unale to parse: " + key);
        GeoJsonPolygon polygon = new GeoJsonPolygon(polygonId);
        String latString = values[3];
        String lonString = values[4];
        double lat = MathUtil.tryParseDoubleOrExit((String)latString, () -> "Unable to parse lat: " + latString);
        double lon = MathUtil.tryParseDoubleOrExit((String)lonString, () -> "Unable to parse lon: " + lonString);
        polygon.addPoint(lon, lat);
        polygon.addProperty("MOID", key);
        polygon.addProperty("TRIP", values[2]);
        byte[] tupleBytes = polygon.toGeoJson().getBytes(Const.DEFAULT_CHARSET);
        if (polygon.getBoundingBox().getDimension() == 0) {
            return null;
        }
        try {
            Date date = this.dateParser.parse(values[0]);
            Hyperrectangle enlargedBox = polygon.getBoundingBox().enlargeByAmount(this.boxPadding);
            return new Tuple(key, enlargedBox, tupleBytes, date.getTime());
        }
        catch (ParseException e) {
            throw new RuntimeException("Unable to decode tuple: " + valueData, e);
        }
    }
}

