/*
 * Decompiled with CFR 0.152.
 */
package org.bboxdb.tools.converter.tuple;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.bboxdb.commons.MathUtil;
import org.bboxdb.commons.math.GeoJsonPolygon;
import org.bboxdb.commons.math.Hyperrectangle;
import org.bboxdb.misc.Const;
import org.bboxdb.storage.entity.Tuple;
import org.bboxdb.tools.converter.tuple.TupleBuilder;

public class BerlinModTupleBuilder
extends TupleBuilder {
    private final SimpleDateFormat dateParser = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public BerlinModTupleBuilder() {
        this.dateParser.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    @Override
    public Tuple buildTuple(String valueData, String keyData) {
        if ("Moid,Tripid,Tstart,Tend,Xstart,Ystart,Xend,Yend".equals(valueData)) {
            return null;
        }
        String[] values = valueData.split(",");
        if (values.length != 8) {
            throw new RuntimeException("Unable to decode tuple: " + valueData);
        }
        String key = keyData != null ? keyData : values[0];
        long polygonId = MathUtil.tryParseLongOrExit((String)key, () -> "Unale to parse: " + key);
        GeoJsonPolygon polygon = new GeoJsonPolygon(polygonId);
        String latString1 = values[4];
        String lonString1 = values[5];
        String latString2 = values[6];
        String lonString2 = values[7];
        double lat1 = MathUtil.tryParseDoubleOrExit((String)latString1, () -> "Unable to parse lat: " + latString1);
        double lon1 = MathUtil.tryParseDoubleOrExit((String)lonString1, () -> "Unable to parse lon: " + lonString1);
        double lat2 = MathUtil.tryParseDoubleOrExit((String)latString2, () -> "Unable to parse lat: " + latString2);
        double lon2 = MathUtil.tryParseDoubleOrExit((String)lonString2, () -> "Unable to parse lon: " + lonString2);
        polygon.addPoint(lon1, lat1);
        polygon.addPoint(lon2, lat2);
        polygon.addProperty("MOID", key);
        polygon.addProperty("TRIP", values[1]);
        byte[] tupleBytes = polygon.toGeoJson().getBytes(Const.DEFAULT_CHARSET);
        if (polygon.getBoundingBox().getDimension() == 0) {
            return null;
        }
        try {
            String dateString = values[2];
            int timeElements = dateString.split(":").length;
            if (timeElements == 1) {
                dateString = dateString.split(" ").length == 1 ? dateString + " 00:00:00" : dateString + ":00:00";
            }
            if (timeElements == 2) {
                dateString = dateString + ":00";
            }
            Date date = this.dateParser.parse(dateString);
            Hyperrectangle enlargedBox = polygon.getBoundingBox().enlargeByAmount(this.boxPadding);
            return new Tuple(key, enlargedBox, tupleBytes, date.getTime());
        }
        catch (ParseException e) {
            throw new RuntimeException("Unable to decode tuple (date parse): " + valueData, e);
        }
    }
}

