/*
 * Decompiled with CFR 0.152.
 */
package org.bboxdb.tools.converter.tuple;

import java.util.Optional;
import org.bboxdb.commons.MathUtil;
import org.bboxdb.commons.math.Hyperrectangle;
import org.bboxdb.storage.entity.Tuple;
import org.bboxdb.tools.converter.tuple.TupleBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Forex1DBuilder
extends TupleBuilder {
    private static final Logger logger = LoggerFactory.getLogger(Forex1DBuilder.class);

    @Override
    public Tuple buildTuple(String valueData, String keyData) {
        try {
            String key = keyData != null ? keyData : this.getKey(valueData);
            String[] data = valueData.split(",");
            if (data.length != 4) {
                throw new IllegalArgumentException("Unable split: " + valueData);
            }
            Optional bid = MathUtil.tryParseDouble((String)data[1]);
            if (!bid.isPresent()) {
                throw new IllegalArgumentException("Unable to parse: " + data[1]);
            }
            Hyperrectangle boundingBox = new Hyperrectangle(new Double[]{(Double)bid.get(), (Double)bid.get()});
            return new Tuple(key, boundingBox.enlargeByAmount(this.boxPadding), valueData.getBytes());
        }
        catch (Exception e) {
            logger.error("Unabe to parse: ", (Throwable)e);
            return null;
        }
    }
}

