/*
 * Decompiled with CFR 0.152.
 */
package org.bboxdb.tools.converter.tuple;

import java.util.Map;
import org.bboxdb.commons.math.GeoJsonPolygon;
import org.bboxdb.commons.math.Hyperrectangle;
import org.bboxdb.storage.entity.Tuple;
import org.bboxdb.tools.converter.tuple.TupleBuilder;

public class GeoJSONTupleBuilder
extends TupleBuilder {
    @Override
    public Tuple buildTuple(String valueData, String keyData) {
        GeoJsonPolygon polygon = GeoJsonPolygon.fromGeoJson((String)valueData);
        String key = keyData != null ? keyData : Long.toString(polygon.getId());
        polygon.invertPolygonCoordinates();
        byte[] tupleBytes = polygon.toGeoJson().getBytes();
        if (polygon.getBoundingBox().getDimension() == 0) {
            return null;
        }
        Hyperrectangle bbox = polygon.getBoundingBox().enlargeByAmount(this.boxPadding);
        Map properties = polygon.getProperties();
        if (properties.containsKey("UpdateTimestamp")) {
            return new Tuple(key, bbox, tupleBytes, Long.parseLong((String)properties.get("UpdateTimestamp")));
        }
        return new Tuple(key, bbox, tupleBytes);
    }
}

