/*
 * Decompiled with CFR 0.152.
 */
package org.bboxdb.tools.converter.tuple;

import org.bboxdb.commons.math.Hyperrectangle;
import org.bboxdb.storage.entity.Tuple;
import org.bboxdb.tools.converter.tuple.TupleBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NariDynamicBuilder
extends TupleBuilder {
    private static final Logger logger = LoggerFactory.getLogger(NariDynamicBuilder.class);

    @Override
    public Tuple buildTuple(String valueData, String keyData) {
        String[] data = valueData.split(",");
        if (data.length != 9) {
            throw new IllegalArgumentException("Unable to split input: " + valueData);
        }
        try {
            String key = keyData != null ? keyData : data[0];
            double time = Double.parseDouble(data[8]);
            double longitude = Double.parseDouble(data[6]);
            double latitude = Double.parseDouble(data[7]);
            Hyperrectangle boundingBox = new Hyperrectangle(new Double[]{time, time, longitude, longitude, latitude, latitude});
            return new Tuple(key, boundingBox.enlargeByAmount(this.boxPadding), valueData.getBytes());
        }
        catch (Exception e) {
            logger.error("Unabe to parse: ", (Throwable)e);
            return null;
        }
    }
}

