/*
 * Decompiled with CFR 0.152.
 */
package org.bboxdb.tools.converter.tuple;

import java.time.LocalDateTime;
import java.time.ZoneId;
import org.bboxdb.commons.math.Hyperrectangle;
import org.bboxdb.storage.entity.Tuple;
import org.bboxdb.tools.converter.tuple.TupleBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RomeTaxiPointBuilder
extends TupleBuilder {
    private final ZoneId zone = ZoneId.of("Europe/Berlin");
    private static final Logger logger = LoggerFactory.getLogger(RomeTaxiPointBuilder.class);

    @Override
    public Tuple buildTuple(String valueData, String keyData) {
        String[] data = valueData.split(";");
        try {
            LocalDateTime date = LocalDateTime.parse(data[1].replaceAll("\\+01", "").replaceAll(" ", "T"));
            if (date == null) {
                throw new IllegalArgumentException("Unable to parse: " + data[1]);
            }
            double dateSeconds = date.atZone(this.zone).toInstant().toEpochMilli();
            String[] longLat = data[2].replaceAll("POINT\\(", "").replaceAll("\\)", "").split(" ");
            double longitude = Double.parseDouble(longLat[0]);
            double latitude = Double.parseDouble(longLat[1]);
            Hyperrectangle boundingBox = new Hyperrectangle(new Double[]{dateSeconds, dateSeconds, longitude, longitude, latitude, latitude});
            return new Tuple(keyData, boundingBox.enlargeByAmount(this.boxPadding), valueData.getBytes());
        }
        catch (Exception e) {
            logger.error("Unabe to parse: ", (Throwable)e);
            return null;
        }
    }
}

