/*
 * Decompiled with CFR 0.152.
 */
package org.bboxdb.tools.converter.tuple;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.Map;
import org.bboxdb.commons.math.Hyperrectangle;
import org.bboxdb.storage.entity.Tuple;
import org.bboxdb.tools.converter.tuple.OldEntry;
import org.bboxdb.tools.converter.tuple.TupleBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RomeTaxiRangeBuilder
extends TupleBuilder {
    private final ZoneId zone = ZoneId.of("Europe/Berlin");
    private final Map<Integer, OldEntry> movementCache = new HashMap<Integer, OldEntry>();
    private static final Logger logger = LoggerFactory.getLogger(RomeTaxiRangeBuilder.class);

    @Override
    public Tuple buildTuple(String valueData, String keyData) {
        String[] data = valueData.split(";");
        try {
            int taxiId = Integer.parseInt(data[0]);
            LocalDateTime date = LocalDateTime.parse(data[1].replaceAll("\\+01", "").replaceAll(" ", "T"));
            if (date == null) {
                throw new IllegalArgumentException("Unable to parse: " + data[1]);
            }
            double dateSeconds = date.atZone(this.zone).toInstant().toEpochMilli();
            String[] longLat = data[2].replaceAll("POINT\\(", "").replaceAll("\\)", "").split(" ");
            double longitude = Double.parseDouble(longLat[0]);
            double latitude = Double.parseDouble(longLat[1]);
            OldEntry currentEntry = new OldEntry(dateSeconds, longitude, latitude);
            if (!this.movementCache.containsKey(taxiId)) {
                this.movementCache.put(taxiId, currentEntry);
                return null;
            }
            OldEntry oldEntry = this.movementCache.get(taxiId);
            this.movementCache.put(taxiId, currentEntry);
            double beginTime = Math.min(oldEntry.getTime(), dateSeconds);
            double endTime = Math.max(oldEntry.getTime(), dateSeconds);
            double beginLongitude = Math.min(oldEntry.getLongitude(), longitude);
            double endLongitude = Math.max(oldEntry.getLongitude(), longitude);
            double beginLatitude = Math.min(oldEntry.getLatitude(), latitude);
            double endLatitude = Math.max(oldEntry.getLatitude(), latitude);
            Hyperrectangle boundingBox = new Hyperrectangle(new Double[]{beginTime, endTime, beginLongitude, endLongitude, beginLatitude, endLatitude});
            return new Tuple(keyData, boundingBox.enlargeByAmount(this.boxPadding), valueData.getBytes());
        }
        catch (Exception e) {
            logger.error("Unabe to parse: ", (Throwable)e);
            return null;
        }
    }
}

