/*
 * Decompiled with CFR 0.152.
 */
package org.bboxdb.tools.converter.tuple;

import org.bboxdb.commons.math.Hyperrectangle;
import org.bboxdb.storage.entity.Tuple;
import org.bboxdb.tools.converter.tuple.TupleBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyntheticDataStreamTupleBuilder
extends TupleBuilder {
    private static final Logger logger = LoggerFactory.getLogger(SyntheticDataStreamTupleBuilder.class);

    @Override
    public Tuple buildTuple(String valueData, String keyData) {
        String[] data = valueData.split(" ");
        if (data.length != 3) {
            throw new RuntimeException("Unable to decode tuple: " + valueData);
        }
        try {
            String key = keyData != null ? keyData : data[0];
            String[] bboxData = data[1].split(",");
            if (bboxData.length % 2 != 0) {
                logger.error("Invalid dimension for bbox data : " + data[1]);
                return null;
            }
            double[] bboxValues = new double[bboxData.length];
            for (int i = 0; i < bboxData.length; ++i) {
                bboxValues[i] = Double.parseDouble(bboxData[i]);
            }
            Hyperrectangle boundingBox = new Hyperrectangle(bboxValues);
            Tuple tuple = new Tuple(key, boundingBox, data[2].getBytes());
            return tuple;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to decode tuple (date parse): " + valueData, e);
        }
    }
}

