/*
 * Decompiled with CFR 0.152.
 */
package org.bboxdb.tools.converter.tuple;

import org.bboxdb.commons.math.Hyperrectangle;
import org.bboxdb.storage.entity.Tuple;
import org.bboxdb.tools.converter.tuple.TupleBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyntheticTupleBuilder
extends TupleBuilder {
    private static final Logger logger = LoggerFactory.getLogger(SyntheticTupleBuilder.class);

    @Override
    public Tuple buildTuple(String valueData, String keyData) {
        try {
            String[] data = valueData.split(" ");
            if (data.length != 2) {
                logger.error("Unable to split line : " + valueData);
                return null;
            }
            String[] bboxData = data[0].split(",");
            if (bboxData.length % 2 != 0) {
                logger.error("Invalid dimension for bbox data : " + data[0]);
                return null;
            }
            double[] bboxValues = new double[bboxData.length];
            for (int i = 0; i < bboxData.length; ++i) {
                bboxValues[i] = Double.parseDouble(bboxData[i]);
            }
            Hyperrectangle boundingBox = new Hyperrectangle(bboxValues);
            Tuple tuple = new Tuple(keyData, boundingBox, data[1].getBytes());
            return tuple;
        }
        catch (NumberFormatException e) {
            logger.error("Unabe to parse: ", (Throwable)e);
            return null;
        }
    }
}

