/*
 * Decompiled with CFR 0.152.
 */
package org.bboxdb.tools.converter.tuple;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.bboxdb.commons.math.Hyperrectangle;
import org.bboxdb.storage.entity.Tuple;
import org.bboxdb.tools.converter.tuple.TupleBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TPCHLineitemRangeBuilder
extends TupleBuilder {
    protected final SimpleDateFormat dateParser = new SimpleDateFormat("yyyy-mm-dd");
    private static final Logger logger = LoggerFactory.getLogger(TPCHLineitemRangeBuilder.class);

    @Override
    public Tuple buildTuple(String valueData, String keyData) {
        String[] data = valueData.split("\\|");
        try {
            Date shipDate = this.dateParser.parse(data[10]);
            Date receiptDate = this.dateParser.parse(data[12]);
            double shipDateTime = shipDate.getTime();
            double receiptDateTime = receiptDate.getTime();
            Hyperrectangle boundingBox = new Hyperrectangle(new Double[]{Math.min(shipDateTime, receiptDateTime), Math.max(shipDateTime, receiptDateTime)});
            return new Tuple(keyData, boundingBox.enlargeByAmount(this.boxPadding), valueData.getBytes());
        }
        catch (ParseException e) {
            logger.error("Unabe to parse: ", (Throwable)e);
            return null;
        }
    }
}

