/*
 * Decompiled with CFR 0.152.
 */
package org.bboxdb.tools.converter.tuple;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.bboxdb.commons.math.Hyperrectangle;
import org.bboxdb.storage.entity.Tuple;
import org.bboxdb.tools.converter.tuple.TupleBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TPCHOrderPointBuilder
extends TupleBuilder {
    protected final SimpleDateFormat dateParser = new SimpleDateFormat("yyyy-mm-dd");
    private static final Logger logger = LoggerFactory.getLogger(TPCHOrderPointBuilder.class);

    @Override
    public Tuple buildTuple(String valueData, String keyData) {
        String[] data = valueData.split("\\|");
        try {
            Date orderDate = this.dateParser.parse(data[4]);
            double orderDateTime = orderDate.getTime();
            Hyperrectangle boundingBox = new Hyperrectangle(new Double[]{orderDateTime, orderDateTime});
            return new Tuple(keyData, boundingBox.enlargeByAmount(this.boxPadding), valueData.getBytes());
        }
        catch (ParseException e) {
            logger.error("Unabe to parse: ", (Throwable)e);
            return null;
        }
    }
}

